"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipOrPopoverIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/components/tooltip_popover_icon/tooltip_popover_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TooltipOrPopoverIcon = ({
  title,
  mode = 'popover',
  icon,
  iconColor = 'warning',
  popoverCss,
  dataTestSubj,
  children
}) => {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const handleButtonClick = togglePopover;
  return mode === 'popover' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    css: popoverCss,
    attachToAnchor: true,
    anchorPosition: "downCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": dataTestSubj,
      "aria-label": title,
      title: title,
      iconType: icon,
      color: iconColor,
      onClick: handleButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, title) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": dataTestSubj,
    "aria-label": title,
    title: title,
    type: icon,
    color: iconColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }), children));
};
exports.TooltipOrPopoverIcon = TooltipOrPopoverIcon;