"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.StreamsAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/dataset-quality-plugin/public");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _css = require("@emotion/css");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _discover_features = require("./discover_features");
var _service = require("./telemetry/service");
var _locators = require("../common/locators");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/streams_app/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StreamsApplication = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./application'))).then(mod => ({
  default: mod.StreamsApplication
})));
const renderApp = ({
  appMountParameters,
  services,
  coreStart,
  pluginsStart,
  isServerless
}) => {
  const {
    element
  } = appMountParameters;
  const appWrapperClassName = (0, _css.css)`
    overflow: auto;
    height: 0;
  `;
  const appWrapperElement = document.getElementsByClassName(_public.APP_WRAPPER_CLASS)[1];
  appWrapperElement.classList.add(appWrapperClassName);
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(StreamsApplication, {
    coreStart: coreStart,
    pluginsStart: pluginsStart,
    services: services,
    isServerless: isServerless,
    appMountParameters: appMountParameters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
    appWrapperElement.classList.remove(_public.APP_WRAPPER_CLASS);
  };
};
exports.renderApp = renderApp;
class StreamsAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "telemetry", new _service.StreamsTelemetryService());
    (0, _defineProperty2.default)(this, "version", void 0);
    this.context = context;
    this.logger = context.logger.get();
    this.version = context.env.packageInfo.version;
  }
  setup(coreSetup) {
    this.telemetry.setup(coreSetup.analytics);
    const startServicesPromise = coreSetup.getStartServices();
    coreSetup.application.register({
      id: 'streams',
      title: _i18n.i18n.translate('xpack.streams.appTitle', {
        defaultMessage: 'Streams'
      }),
      euiIconType: 'logoElastic',
      appRoute: '/app/streams',
      category: _public.DEFAULT_APP_CATEGORIES.management,
      order: 10000,
      updater$: (0, _rxjs.from)(startServicesPromise).pipe((0, _rxjs.switchMap)(([_, pluginsStart]) => pluginsStart.streams.navigationStatus$.pipe((0, _rxjs.map)(({
        status
      }) => {
        return app => {
          if (status !== 'enabled') {
            return {
              visibleIn: []
            };
          }
          return {
            visibleIn: ['sideNav', 'globalSearch']
          };
        };
      })))),
      mount: async appMountParameters => {
        // Load application bundle and Get start services
        const [coreStart, pluginsStart] = await coreSetup.getStartServices();
        const services = {
          dataStreamsClient: new _public2.DataStreamsStatsService().start({
            http: coreStart.http
          }).getClient(),
          telemetryClient: this.telemetry.getClient(),
          version: this.version
        };

        // Trigger fetch to ensure the time filter has an up-to-date time range when the app mounts.
        // This is done to ensure that dynamic time ranges (like "Last 15 minutes") are applied like they
        // would be in discover or dashboards.
        pluginsStart.data.query.timefilter.timefilter.triggerFetch();
        return renderApp({
          appMountParameters,
          services,
          coreStart,
          pluginsStart,
          isServerless: this.context.env.packageInfo.buildFlavor === 'serverless'
        });
      }
    });
    return {};
  }
  start(coreStart, pluginsStart) {
    const locator = pluginsStart.share.url.locators.create(new _locators.StreamsAppLocatorDefinition());
    pluginsStart.streams.navigationStatus$.subscribe(status => {
      if (status.status !== 'enabled') return;
      pluginsStart.discoverShared.features.registry.register({
        id: 'streams',
        renderFlyoutStreamField: (0, _discover_features.createDiscoverFlyoutStreamFieldLink)({
          streamsRepositoryClient: pluginsStart.streams.streamsRepositoryClient,
          locator,
          coreApplication: coreStart.application
        }),
        renderFlyoutStreamProcessingLink: (0, _discover_features.createDiscoverFlyoutStreamProcessingLink)({
          streamsRepositoryClient: pluginsStart.streams.streamsRepositoryClient,
          locator,
          coreApplication: coreStart.application
        })
      });
    });
    return {};
  }
}
exports.StreamsAppPlugin = StreamsAppPlugin;