"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareStreamsForImport = prepareStreamsForImport;
var _lodash = require("lodash");
var _tree = require("./tree");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function prepareStreamsForImport({
  existing,
  incoming
}) {
  return flattenTree((0, _tree.mergeTrees)({
    existing,
    incoming
  }));
}
function flattenTree(tree) {
  return [(0, _lodash.omit)(tree, 'children'), ...tree.children.flatMap(flattenTree)];
}