"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetStorageSettings = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetStorageSettings = exports.assetStorageSettings = {
  name: '.kibana_streams_assets',
  schema: {
    properties: {
      [_fields.ASSET_UUID]: _storageAdapter.types.keyword(),
      [_fields.ASSET_ID]: _storageAdapter.types.keyword(),
      [_fields.ASSET_TYPE]: _storageAdapter.types.keyword(),
      [_fields.STREAM_NAME]: _storageAdapter.types.keyword(),
      [_fields.QUERY_KQL_BODY]: _storageAdapter.types.match_only_text(),
      [_fields.QUERY_TITLE]: _storageAdapter.types.keyword(),
      experimental: _storageAdapter.types.object({
        enabled: false
      })
    }
  }
};