"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestClassic = exports.ClassicStream = exports.ClassicIngest = void 0;
var _zod = require("@kbn/zod");
var _base = require("./base");
var _lifecycle = require("./lifecycle");
var _common = require("./common");
var _validation = require("../validation/validation");
var _model_validation = require("../validation/model_validation");
var _base2 = require("../base");
var _settings = require("./settings");
var _fields = require("../../fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/no-namespace */

const IngestClassic = exports.IngestClassic = _zod.z.object({
  classic: _zod.z.object({
    field_overrides: _zod.z.optional(_fields.fieldDefinitionSchema)
  })
});
const ClassicIngest = exports.ClassicIngest = (0, _validation.validation)(_base.IngestBase.right, _zod.z.intersection(_base.IngestBase.right, IngestClassic));
const ClassicStream = exports.ClassicStream = (0, _model_validation.modelValidation)(_base2.BaseStream, {
  Definition: _zod.z.intersection(_base.IngestBaseStream.Definition.right, _zod.z.object({
    ingest: IngestClassic
  })),
  Source: _zod.z.intersection(_base.IngestBaseStream.Source.right, _zod.z.object({})),
  GetResponse: _zod.z.intersection(_base.IngestBaseStream.GetResponse.right, _zod.z.object({
    elasticsearch_assets: _zod.z.optional(_common.elasticsearchAssetsSchema),
    data_stream_exists: _zod.z.boolean(),
    effective_lifecycle: _lifecycle.classicIngestStreamEffectiveLifecycleSchema,
    effective_settings: _settings.ingestStreamSettingsSchema
  })),
  UpsertRequest: _zod.z.intersection(_base.IngestBaseStream.UpsertRequest.right, _zod.z.object({}))
});

// Optimized implementation for Definition check - the fallback is a zod-based check
ClassicStream.Definition.is = stream => Boolean('ingest' in stream && typeof stream.ingest === 'object' && stream.ingest && 'classic' in stream.ingest);