"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowSelectedFilters = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/embeddables/common/show_selected_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ShowSelectedFilters = ({
  filters
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  }, Object.entries(filters).map(([key, filter]) => {
    if (!filter || !filter.length) {
      return null;
    }
    const values = filter.map(f => f.label || f.value).join(', ');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      key: key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.synthetics.showSelectedFilters.monitorBadgeLabel', {
      defaultMessage: '{label}: {value}',
      values: {
        label: labels[key],
        value: values
      }
    }));
  }));
};
exports.ShowSelectedFilters = ShowSelectedFilters;
const labels = {
  monitorIds: _i18n.i18n.translate('xpack.synthetics.showSelectedFilters.monitorIdLabel', {
    defaultMessage: 'Monitor'
  }),
  tags: _i18n.i18n.translate('xpack.synthetics.showSelectedFilters.tagsLabel', {
    defaultMessage: 'Tags'
  }),
  locations: _i18n.i18n.translate('xpack.synthetics.showSelectedFilters.locationsLabel', {
    defaultMessage: 'Location'
  }),
  monitorTypes: _i18n.i18n.translate('xpack.synthetics.showSelectedFilters.monitorTypeLabel', {
    defaultMessage: 'Type'
  }),
  projects: _i18n.i18n.translate('xpack.synthetics.showSelectedFilters.presetLabel', {
    defaultMessage: 'Project'
  })
};