"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationsValueExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _popover_expression = require("./popover_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/common/condition_locations_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LocationsValueExpression = ({
  ruleParams,
  setRuleParams
}) => {
  var _condition$locationsT;
  const {
    condition
  } = ruleParams;
  const onLocationCountChange = (0, _react.useCallback)(value => {
    var _ruleParams$condition;
    setRuleParams('condition', {
      ...ruleParams.condition,
      locationsThreshold: value,
      groupBy: value === 1 ? (_ruleParams$condition = ruleParams.condition) === null || _ruleParams$condition === void 0 ? void 0 : _ruleParams$condition.groupBy : 'none'
    });
  }, [ruleParams.condition, setRuleParams]);
  const locationsThreshold = condition && 'locationsThreshold' in condition ? (_condition$locationsT = condition.locationsThreshold) !== null && _condition$locationsT !== void 0 ? _condition$locationsT : 1 : 1;
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: _i18n.i18n.translate('xpack.synthetics.windowValueExpression.percentLabel', {
      defaultMessage: '{numberOfLocations} {numberOfLocations, plural, one {location} other {locations}}',
      values: {
        numberOfLocations: locationsThreshold
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.synthetics.windowValueExpression.numberOfLocPopoverTitleLabel', {
    defaultMessage: 'Number of locations'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "syntheticsWindowValueExpressionFieldNumber",
    min: 1,
    max: 100,
    compressed: true,
    value: locationsThreshold,
    onChange: evt => onLocationCountChange(Number(evt.target.value)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
};
exports.LocationsValueExpression = LocationsValueExpression;