"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationsField = LocationsField;
exports.MonitorField = MonitorField;
exports.MonitorTypeField = MonitorTypeField;
exports.ProjectsField = ProjectsField;
exports.TagsField = TagsField;
exports.allOptionText = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _field_popover_expression = require("./field_popover_expression");
var _field_selector = require("./field_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/common/fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const allOptionText = exports.allOptionText = _i18n.i18n.translate('xpack.synthetics.filter.alert.allLabel', {
  defaultMessage: 'All'
});
function MonitorField({
  value,
  onChange,
  ...rest
}) {
  return /*#__PURE__*/_react.default.createElement(_field_popover_expression.FieldPopoverExpression, {
    value: value,
    title: _i18n.i18n.translate('xpack.synthetics.alerting.fields.monitor', {
      defaultMessage: 'Monitor'
    }),
    fieldName: "monitorIds",
    selectedField: rest.selectedField,
    setSelectedField: rest.setSelectedField,
    allSuggestions: rest.allSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, (0, _extends2.default)({
    value: value,
    fieldName: "monitorIds",
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.synthetics.monitorNamesSelectPlaceholder', {
      defaultMessage: 'Select monitor name'
    }),
    dataTestSubj: "monitorNameField"
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  })));
}
function TagsField({
  value,
  onChange,
  ...rest
}) {
  return /*#__PURE__*/_react.default.createElement(_field_popover_expression.FieldPopoverExpression, {
    value: value,
    title: _i18n.i18n.translate('xpack.synthetics.alerting.fields.tags', {
      defaultMessage: 'Tags'
    }),
    fieldName: "tags",
    selectedField: rest.selectedField,
    setSelectedField: rest.setSelectedField,
    allSuggestions: rest.allSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, (0, _extends2.default)({
    value: value,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.synthetics.tagsSelectPlaceholder', {
      defaultMessage: 'Select tags'
    }),
    dataTestSubj: "tagsField",
    fieldName: "tags"
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  })));
}
function MonitorTypeField({
  value,
  onChange,
  ...rest
}) {
  const label = _i18n.i18n.translate('xpack.synthetics.alerting.fields.type', {
    defaultMessage: 'Type'
  });
  return /*#__PURE__*/_react.default.createElement(_field_popover_expression.FieldPopoverExpression, {
    value: value,
    title: label,
    fieldName: "monitorTypes",
    selectedField: rest.selectedField,
    setSelectedField: rest.setSelectedField,
    allSuggestions: rest.allSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, (0, _extends2.default)({
    value: value,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.synthetics.monitorTypesSelectPlaceholder', {
      defaultMessage: 'Select monitor type'
    }),
    dataTestSubj: "monitorTypeField",
    fieldName: "monitorTypes"
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  })));
}
function LocationsField({
  value,
  onChange,
  ...rest
}) {
  const label = _i18n.i18n.translate('xpack.synthetics.alerting.fields.location', {
    defaultMessage: 'Locations'
  });
  return /*#__PURE__*/_react.default.createElement(_field_popover_expression.FieldPopoverExpression, {
    value: value,
    title: label,
    fieldName: "locations",
    selectedField: rest.selectedField,
    setSelectedField: rest.setSelectedField,
    allSuggestions: rest.allSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, (0, _extends2.default)({
    value: value,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.synthetics.locationSelectPlaceholder', {
      defaultMessage: 'Select location'
    }),
    dataTestSubj: "monitorLocationField",
    fieldName: "locations"
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  })));
}
function ProjectsField({
  value,
  onChange,
  ...rest
}) {
  const label = _i18n.i18n.translate('xpack.synthetics.alerting.fields.project', {
    defaultMessage: 'Projects'
  });
  return /*#__PURE__*/_react.default.createElement(_field_popover_expression.FieldPopoverExpression, {
    value: value,
    title: label,
    fieldName: "projects",
    selectedField: rest.selectedField,
    setSelectedField: rest.setSelectedField,
    allSuggestions: rest.allSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, (0, _extends2.default)({
    value: value,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.synthetics.projectSelectPlaceholder', {
      defaultMessage: 'Select project'
    }),
    dataTestSubj: "monitorProjectField",
    fieldName: "projects"
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  })));
}