"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _synthetics_refresh_context = require("../../../contexts/synthetics_refresh_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/auto_refresh_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AutoRefreshButton = () => {
  const {
    refreshInterval,
    setRefreshInterval,
    refreshPaused,
    setRefreshPaused
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const onRefreshChange = newProps => {
    setRefreshPaused(newProps.isPaused);
    setRefreshInterval(newProps.refreshInterval / 1000);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAutoRefreshButton, {
    size: "m",
    isPaused: refreshPaused,
    refreshInterval: refreshInterval * 1000,
    onRefreshChange: onRefreshChange,
    shortHand: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
};
exports.AutoRefreshButton = AutoRefreshButton;