"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewDocument = exports.INSPECT_DOCUMENT = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _synthetics_data_view_context = require("../../../contexts/synthetics_data_view_context");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/view_document.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ViewDocument = ({
  ping
}) => {
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const dataView = (0, _synthetics_data_view_context.useSyntheticsDataView)();
  const formatter = (0, _use_date_format.useDateFormat)();
  const formattedTimestamp = formatter(ping['@timestamp']);
  const [, hit] = (0, _public.useEsDocSearch)({
    id: ping.docId,
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    dataView
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "syntheticsViewDocumentButton",
    iconType: "inspect",
    title: INSPECT_DOCUMENT(formattedTimestamp),
    "aria-label": INSPECT_DOCUMENT(formattedTimestamp),
    onClick: evt => {
      evt.stopPropagation();
      setIsFlyoutVisible(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setIsFlyoutVisible(false),
    ownFocus: true,
    onClick: evt => {
      // needed to prevent propagation to the table row click
      evt.stopPropagation();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 15
    }
  }, INDEXED_AT, " ", formattedTimestamp))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, dataView !== null && dataView !== void 0 && dataView.id && hit ? /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewer, {
    hit: hit,
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 15
    }
  }))));
};
exports.ViewDocument = ViewDocument;
const INDEXED_AT = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.indexedAt', {
  defaultMessage: 'Indexed at'
});
const INSPECT_DOCUMENT = timestamp => _i18n.i18n.translate('xpack.synthetics.monitorDetails.action.inspectDocument', {
  defaultMessage: 'Inspect document timestamped {timestamp}',
  values: {
    timestamp
  }
});
exports.INSPECT_DOCUMENT = INSPECT_DOCUMENT;