"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SinglePingResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/monitor_test_result/single_ping_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SinglePingResult = ({
  ping
}) => {
  var _ping$resolve, _ping$monitor$duratio, _ping$monitor, _ping$monitor$duratio2, _ping$resolve$rtt$us, _ping$resolve2, _ping$resolve2$rtt, _ping$url, _ping$http, _ping$http$response;
  const ip = ping === null || ping === void 0 ? void 0 : (_ping$resolve = ping.resolve) === null || _ping$resolve === void 0 ? void 0 : _ping$resolve.ip;
  const durationUs = (_ping$monitor$duratio = ping === null || ping === void 0 ? void 0 : (_ping$monitor = ping.monitor) === null || _ping$monitor === void 0 ? void 0 : (_ping$monitor$duratio2 = _ping$monitor.duration) === null || _ping$monitor$duratio2 === void 0 ? void 0 : _ping$monitor$duratio2.us) !== null && _ping$monitor$duratio !== void 0 ? _ping$monitor$duratio : NaN;
  const rtt = (_ping$resolve$rtt$us = ping === null || ping === void 0 ? void 0 : (_ping$resolve2 = ping.resolve) === null || _ping$resolve2 === void 0 ? void 0 : (_ping$resolve2$rtt = _ping$resolve2.rtt) === null || _ping$resolve2$rtt === void 0 ? void 0 : _ping$resolve2$rtt.us) !== null && _ping$resolve$rtt$us !== void 0 ? _ping$resolve$rtt$us : NaN;
  const url = ping === null || ping === void 0 ? void 0 : (_ping$url = ping.url) === null || _ping$url === void 0 ? void 0 : _ping$url.full;
  const responseStatus = ping === null || ping === void 0 ? void 0 : (_ping$http = ping.http) === null || _ping$http === void 0 ? void 0 : (_ping$http$response = _ping$http.response) === null || _ping$http$response === void 0 ? void 0 : _ping$http$response.status_code;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.synthetics.singlePingResult.ipDescriptionListTitleLabel', {
    defaultMessage: 'IP'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, ip), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, DURATION_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, isNaN(durationUs) ? '' : (0, _test_time_formats.formatTestDuration)(durationUs)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.synthetics.singlePingResult.rttDescriptionListTitleLabel', {
    defaultMessage: 'rtt'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, isNaN(rtt) ? '' : (0, _test_time_formats.formatTestDuration)(rtt)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.synthetics.singlePingResult.urlDescriptionListTitleLabel', {
    defaultMessage: 'URL'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsSinglePingResultLink",
    href: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, url)), responseStatus ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.synthetics.singlePingResult.responseStatusDescriptionListTitleLabel', {
    defaultMessage: 'Response status'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }, responseStatus))) : null));
};
exports.SinglePingResult = SinglePingResult;
const DURATION_LABEL = _i18n.i18n.translate('xpack.synthetics.monitor.duration.label', {
  defaultMessage: 'Duration'
});