"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseBadgeStatus = exports.getTextColorForMonitorStatus = exports.getBadgeColorForMonitorStatus = exports.StatusBadge = exports.SKIPPED_LABEL = exports.FAILED_LABEL = exports.COMPLETE_LABEL = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/monitor_test_result/status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatusBadge = ({
  status
}) => {
  if (status === 'unknown') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 16,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: getBadgeColorForMonitorStatus(status),
    css: {
      maxWidth: 'max-content'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  }, status === 'succeeded' ? COMPLETE_LABEL : status === 'failed' ? FAILED_LABEL : SKIPPED_LABEL);
};
exports.StatusBadge = StatusBadge;
const parseBadgeStatus = status => {
  switch (status) {
    case 'succeeded':
    case 'success':
    case 'up':
      return 'succeeded';
    case 'fail':
    case 'failed':
    case 'down':
      return 'failed';
    case 'skip':
    case 'skipped':
      return 'skipped';
    default:
      return 'unknown';
  }
};
exports.parseBadgeStatus = parseBadgeStatus;
const getBadgeColorForMonitorStatus = status => {
  return status === 'succeeded' ? 'success' : status === 'failed' ? 'danger' : 'default';
};
exports.getBadgeColorForMonitorStatus = getBadgeColorForMonitorStatus;
const getTextColorForMonitorStatus = status => {
  return status === 'skipped' ? 'textDisabled' : 'textParagraph';
};
exports.getTextColorForMonitorStatus = getTextColorForMonitorStatus;
const COMPLETE_LABEL = exports.COMPLETE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.complete', {
  defaultMessage: 'Complete'
});
const FAILED_LABEL = exports.FAILED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.failed', {
  defaultMessage: 'Failed'
});
const SKIPPED_LABEL = exports.SKIPPED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatus.skipped', {
  defaultMessage: 'Skipped'
});