"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceLocationsField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _location_formatter = require("../../../../../../common/utils/location_formatter");
var _state = require("../../../state");
var _monitor_management = require("../../../../../../common/constants/monitor_management");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/getting_started/form_fields/service_locations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ServiceLocationsField = ({
  control,
  onChange
}) => {
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const fieldState = control.getFieldState(_monitor_management.ConfigKey.LOCATIONS);
  const showError = fieldState.isTouched || control._formState.isSubmitted;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: LOCATIONS_LABEL,
    helpText: showError && fieldState.invalid ? undefined : SELECT_ONE_OR_MORE_LOCATIONS_DETAILS,
    isInvalid: showError && fieldState.invalid,
    error: showError ? SELECT_ONE_OR_MORE_LOCATIONS : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _monitor_management.ConfigKey.LOCATIONS,
    control: control,
    rules: {
      validate: {
        notEmpty: value => {
          return (value === null || value === void 0 ? void 0 : value.length) > 0 ? true : SELECT_ONE_OR_MORE_LOCATIONS;
        }
      }
    },
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(ComboBoxWithRef, (0, _extends2.default)({
      fullWidth: true,
      "aria-label": SELECT_ONE_OR_MORE_LOCATIONS,
      options: locations.map(location => ({
        ...location,
        'data-test-subj': `syntheticsServiceLocation--${location.id}`
      })),
      selectedOptions: field.value,
      isClearable: true,
      "data-test-subj": "syntheticsServiceLocations"
    }, field, {
      onChange: async selectedOptions => {
        const updatedLocations = selectedOptions.map(loc => (0, _location_formatter.formatLocation)(loc));
        field.onChange(updatedLocations);
        onChange(updatedLocations);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }));
};
exports.ServiceLocationsField = ServiceLocationsField;
const ComboBoxWithRef = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, props, {
  inputRef: element => {
    if (ref) {
      if (typeof ref === 'function') {
        ref(element);
      } else {
        ref.current = element;
      }
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 81,
    columnNumber: 5
  }
})));
const SELECT_ONE_OR_MORE_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.selectOneOrMoreLocations', {
  defaultMessage: 'Select one or more locations.'
});
const SELECT_ONE_OR_MORE_LOCATIONS_DETAILS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.selectOneOrMoreLocationsDetails', {
  defaultMessage: 'Select locations where monitors will be executed.'
});
const LOCATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.locationsLabel', {
  defaultMessage: 'Locations'
});