"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditMonitorNotFound = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _api = require("../../state/monitor_management/api");
var _monitor_not_found_page = require("../monitor_details/monitor_not_found_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/edit_monitor_not_found.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditMonitorNotFound = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LeftoverIntegrationFound, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_not_found_page.MonitorNotFoundPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 7
    }
  }));
};
exports.EditMonitorNotFound = EditMonitorNotFound;
const LeftoverIntegrationFound = () => {
  const {
    packagePolicyId
  } = (0, _hooks.useGetUrlParams)();
  const updateUrlParams = (0, _hooks.useUrlParams)()[1];
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    if (!packagePolicyId || !isDeleting) return;
    return (0, _api.deletePackagePolicy)(packagePolicyId);
  }, [isDeleting, packagePolicyId]);
  (0, _react.useEffect)(() => {
    if (isDeleting && data && !loading) {
      updateUrlParams({
        packagePolicyId: undefined
      }, true);
      setIsDeleting(false);
    }
  }, [data, isDeleting, loading, updateUrlParams]);
  if (!packagePolicyId) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Leftover integration found",
    color: "warning",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.leftOver.errors.title",
    defaultMessage: "Please click on the button below to delete the integration. Normally this should not happen. Since the monitor has been deleted, the integration was supposed to be deleted automatically. If this happens often, report it by ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsLeftoverIntegrationFoundCreatingAnIssueLink",
    href: "https://github.com/elastic/kibana/issues/new/choose",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.leftOver.errors.createIssue",
    defaultMessage: "creating an issue.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsUseMonitorNotFoundDeleteIntegrationButton",
    color: "danger",
    isLoading: loading && isDeleting,
    onClick: () => {
      setIsDeleting(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.leftOver.errors.delete",
    defaultMessage: "Delete integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
};