"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestBodyField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _queryString = require("query-string");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _types = require("../types");
var _key_value_field = require("./key_value_field");
var _code_editor = require("./code_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/request_body_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ResponseBodyType = /*#__PURE__*/function (ResponseBodyType) {
  ResponseBodyType["CODE"] = "code";
  ResponseBodyType["FORM"] = "form";
  return ResponseBodyType;
}(ResponseBodyType || {}); // TO DO: Look into whether or not code editor reports errors, in order to prevent form submission on an error
const RequestBodyField = ({
  onChange,
  onBlur,
  value: {
    type,
    value
  },
  readOnly
}) => {
  const [values, setValues] = (0, _react.useState)({
    [ResponseBodyType.FORM]: type === _types.CodeEditorMode.FORM ? value : '',
    [ResponseBodyType.CODE]: type !== _types.CodeEditorMode.FORM ? value : ''
  });
  (0, _react.useEffect)(() => {
    onChange({
      type,
      value: type === _types.CodeEditorMode.FORM ? values[ResponseBodyType.FORM] : values[ResponseBodyType.CODE]
    });
  }, [onChange, type, values]);
  const handleSetMode = (0, _react.useCallback)(currentMode => {
    onChange({
      type: currentMode,
      value: currentMode === _types.CodeEditorMode.FORM ? values[ResponseBodyType.FORM] : values[ResponseBodyType.CODE]
    });
  }, [onChange, values]);
  const onChangeFormFields = (0, _react.useCallback)(pairs => {
    const formattedPairs = pairs.reduce((acc, header) => {
      const [key, pairValue] = header;
      if (key) {
        return {
          ...acc,
          [key]: pairValue
        };
      }
      return acc;
    }, {});
    return setValues(prevValues => ({
      ...prevValues,
      [_types.CodeEditorMode.FORM]: (0, _queryString.stringify)(formattedPairs)
    }));
  }, [setValues]);
  const defaultFormPairs = (0, _react.useMemo)(() => {
    const pairs = (0, _queryString.parse)(values[_types.CodeEditorMode.FORM]);
    const keys = Object.keys(pairs);
    const formattedPairs = keys.map(key => {
      // key, value, checked;
      return [key, `${pairs[key]}`];
    });
    return formattedPairs;
  }, [values]);
  const tabs = [{
    id: _types.CodeEditorMode.PLAINTEXT,
    name: modeLabels[_types.CodeEditorMode.PLAINTEXT],
    'data-test-subj': `syntheticsRequestBodyTab__${_types.CodeEditorMode.PLAINTEXT}`,
    content: /*#__PURE__*/_react.default.createElement(_code_editor.CodeEditor, {
      ariaLabel: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.requestBody.codeEditor.text.ariaLabel', {
        defaultMessage: 'Text code editor'
      }),
      id: _types.CodeEditorMode.PLAINTEXT,
      languageId: _types.MonacoEditorLangId.PLAINTEXT,
      onChange: code => {
        setValues(prevValues => ({
          ...prevValues,
          [ResponseBodyType.CODE]: code
        }));
        onBlur === null || onBlur === void 0 ? void 0 : onBlur();
      },
      value: values[ResponseBodyType.CODE],
      readOnly: readOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    })
  }, {
    id: _types.CodeEditorMode.JSON,
    name: modeLabels[_types.CodeEditorMode.JSON],
    'data-test-subj': `syntheticsRequestBodyTab__${_types.CodeEditorMode.JSON}`,
    content: /*#__PURE__*/_react.default.createElement(_code_editor.CodeEditor, {
      ariaLabel: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.requestBody.codeEditor.json.ariaLabel', {
        defaultMessage: 'JSON code editor'
      }),
      id: _types.CodeEditorMode.JSON,
      languageId: _types.MonacoEditorLangId.JSON,
      onChange: code => {
        setValues(prevValues => ({
          ...prevValues,
          [ResponseBodyType.CODE]: code
        }));
        onBlur === null || onBlur === void 0 ? void 0 : onBlur();
      },
      value: values[ResponseBodyType.CODE],
      readOnly: readOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    })
  }, {
    id: _types.CodeEditorMode.XML,
    name: modeLabels[_types.CodeEditorMode.XML],
    'data-test-subj': `syntheticsRequestBodyTab__${_types.CodeEditorMode.XML}`,
    content: /*#__PURE__*/_react.default.createElement(_code_editor.CodeEditor, {
      ariaLabel: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.requestBody.codeEditor.xml.ariaLabel', {
        defaultMessage: 'XML code editor'
      }),
      id: _types.CodeEditorMode.XML,
      languageId: _types.MonacoEditorLangId.XML,
      onChange: code => {
        setValues(prevValues => ({
          ...prevValues,
          [ResponseBodyType.CODE]: code
        }));
        onBlur === null || onBlur === void 0 ? void 0 : onBlur();
      },
      value: values[ResponseBodyType.CODE],
      readOnly: readOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 9
      }
    })
  }, {
    id: _types.CodeEditorMode.FORM,
    name: modeLabels[_types.CodeEditorMode.FORM],
    'data-test-subj': `syntheticsRequestBodyTab__${_types.CodeEditorMode.FORM}`,
    content: /*#__PURE__*/_react.default.createElement(_key_value_field.KeyValuePairsField, {
      addPairControlLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.createPackagePolicy.stepConfigure.requestBody.formField.addFormField.label",
        defaultMessage: "Add form field",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 13
        }
      }),
      "data-test-subj": 'syntheticsFormField',
      defaultPairs: defaultFormPairs,
      onChange: onChangeFormFields,
      onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
      readOnly: readOnly,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    css: readOnly ? {
      cursor: 'not-allowed'
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    css: readOnly ? {
      pointerEvents: 'none'
    } : undefined,
    initialSelectedTab: tabs.find(tab => tab.id === type),
    autoFocus: "selected",
    onTabClick: tab => {
      handleSetMode(tab.id);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }));
};
exports.RequestBodyField = RequestBodyField;
const modeLabels = {
  [_types.CodeEditorMode.FORM]: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.requestBodyType.form', {
    defaultMessage: 'Form'
  }),
  [_types.CodeEditorMode.PLAINTEXT]: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.requestBodyType.text', {
    defaultMessage: 'Text'
  }),
  [_types.CodeEditorMode.JSON]: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.requestBodyType.JSON', {
    defaultMessage: 'JSON'
  }),
  [_types.CodeEditorMode.XML]: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.requestBodyType.XML', {
    defaultMessage: 'XML'
  })
};