"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _public = require("@kbn/observability-shared-plugin/public");
var _hooks = require("../../../hooks");
var _run_test_btn = require("./run_test_btn");
var _use_capabilities = require("../../../../../hooks/use_capabilities");
var _use_monitor_save = require("../hooks/use_monitor_save");
var _permissions = require("../../common/components/permissions");
var _delete_monitor = require("../../monitors_page/management/monitor_list_table/delete_monitor");
var _types = require("../types");
var _formatter = require("./formatter");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/form/submit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionBar = ({
  readOnly = false,
  canUsePublicLocations = true
}) => {
  var _defaultValues$Config;
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    handleSubmit,
    formState: {
      defaultValues,
      isValid
    }
  } = (0, _reactHookForm.useFormContext)();
  const [monitorsPendingDeletion, setMonitorsPendingDeletion] = (0, _react.useState)([]);
  const [monitorData, setMonitorData] = (0, _react.useState)(undefined);
  const {
    status,
    loading,
    isEdit
  } = (0, _use_monitor_save.useMonitorSave)({
    monitorData
  });
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const {
    isServiceAllowed
  } = (0, _hooks.useEnablement)();
  const formSubmitter = formData => {
    if (isValid) {
      setMonitorData((0, _formatter.format)(formData, readOnly));
    }
  };
  return status === _public.FETCH_STATUS.SUCCESS ? /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _constants.MONITORS_ROUTE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, isEdit && defaultValues && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsActionBarButton",
    color: "danger",
    onClick: () => {
      setMonitorsPendingDeletion([monitorId]);
    },
    isDisabled: !canEditSynthetics || !canUsePublicLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  }, DELETE_MONITOR_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsActionBarLink",
    href: history.createHref({
      pathname: _constants.MONITORS_ROUTE
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, CANCEL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_run_test_btn.RunTestButton, {
    canUsePublicLocations: canUsePublicLocations,
    isServiceAllowed: isServiceAllowed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginLeft: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics,
    canUsePublicLocations: canUsePublicLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: loading,
    onClick: handleSubmit(formSubmitter),
    "data-test-subj": "syntheticsMonitorConfigSubmitButton",
    disabled: !canEditSynthetics || !canUsePublicLocations || !isServiceAllowed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, isEdit ? UPDATE_MONITOR_LABEL : CREATE_MONITOR_LABEL)))), monitorsPendingDeletion.length > 0 && /*#__PURE__*/_react.default.createElement(_delete_monitor.DeleteMonitor, {
    configIds: monitorsPendingDeletion,
    name: (_defaultValues$Config = defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues[_types.ConfigKey.NAME]) !== null && _defaultValues$Config !== void 0 ? _defaultValues$Config : '',
    reloadPage: () => {
      history.push(_constants.MONITORS_ROUTE);
    },
    setMonitorPendingDeletion: setMonitorsPendingDeletion,
    isProjectMonitor: (defaultValues === null || defaultValues === void 0 ? void 0 : defaultValues[_types.ConfigKey.MONITOR_SOURCE_TYPE]) === _types.SourceType.PROJECT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }));
};
exports.ActionBar = ActionBar;
const CANCEL_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.discardLabel', {
  defaultMessage: 'Cancel'
});
const CREATE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.addEdit.createMonitorLabel', {
  defaultMessage: 'Create monitor'
});
const DELETE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.addEdit.deleteMonitorLabel', {
  defaultMessage: 'Delete monitor'
});
const UPDATE_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.updateMonitorLabel', {
  defaultMessage: 'Update monitor'
});