"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusLegend = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var labels = _interopRequireWildcard(require("./labels"));
var _monitor_status_data = require("./monitor_status_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_status/monitor_status_legend.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorStatusLegend = ({
  brushable
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isAmsterdam = euiTheme.flags.hasVisColorAdjustment;
  const SUCCESS_COLOR = isAmsterdam ? _eui.VISUALIZATION_COLORS[0] : euiTheme.colors.success;
  const DANGER_COLOR = isAmsterdam ? _eui.VISUALIZATION_COLORS[_eui.VISUALIZATION_COLORS.length - 1] : euiTheme.colors.danger;
  const LegendItem = (0, _react.useMemo)(() => {
    return ({
      color,
      label,
      iconType = 'dot'
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: {
        display: 'flex',
        flexDirection: 'row',
        gap: 2
      },
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: iconType,
      color: color,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }, label));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(LegendItem, {
    color: SUCCESS_COLOR,
    label: labels.COMPLETE_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(LegendItem, {
    color: DANGER_COLOR,
    label: labels.FAILED_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(LegendItem, {
    color: (0, _monitor_status_data.getSkippedVizColor)(euiTheme),
    label: labels.SKIPPED_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }), brushable ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "aria-hidden": true,
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: euiTheme.colors.textSubdued,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, labels.BRUSH_AREA_MESSAGE))) : null);
};
exports.MonitorStatusLegend = MonitorStatusLegend;