"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditMonitorLink = exports.EditMonitorContextItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_capabilities = require("../../../../../hooks/use_capabilities");
var _contexts = require("../../../contexts");
var _permissions = require("../../common/components/permissions");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/edit_monitor_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditMonitorLink = () => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const isLinkDisabled = !canEditSynthetics;
  const linkProps = isLinkDisabled ? {
    disabled: true
  } : {
    href: `${basePath}/app/synthetics/edit-monitor/${monitorId}` + (spaceId ? `?spaceId=${spaceId}` : '')
  };
  return /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
    canEditSynthetics: canEditSynthetics,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "syntheticsEditMonitorLinkButton",
    fill: true,
    iconType: "pencil",
    iconSide: "left"
  }, linkProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }), EDIT_MONITOR));
};
exports.EditMonitorLink = EditMonitorLink;
const EditMonitorContextItem = () => {
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const isLinkDisabled = !canEditSynthetics;
  const linkProps = isLinkDisabled ? {
    disabled: true
  } : {
    href: `${basePath}/app/synthetics/edit-monitor/${monitorId}` + (spaceId ? `?spaceId=${spaceId}` : '')
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    icon: 'pencil',
    "data-test-subj": "syntheticsEditMonitorContextItem"
  }, linkProps, {
    disabled: isLinkDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }), EDIT_MONITOR);
};
exports.EditMonitorContextItem = EditMonitorContextItem;
const EDIT_MONITOR = _i18n.i18n.translate('xpack.synthetics.monitorSummary.editMonitor', {
  defaultMessage: 'Edit monitor'
});