"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClearFilters = ClearFilters;
exports.NoMonitorsFound = NoMonitorsFound;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/common/no_monitors_found.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function NoMonitorsFound() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "search",
    iconColor: "subdued",
    title: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 18,
        columnNumber: 14
      }
    }, NO_MONITORS_FOUND_HEADING),
    titleSize: "s",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 9
      }
    }, NO_MONITORS_FOUND_CONTENT, " ", /*#__PURE__*/_react.default.createElement(ClearFilters, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 39
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  });
}
function ClearFilters() {
  const [_, updateUrlParams] = (0, _hooks.useUrlParams)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsClearFiltersLink",
    onClick: () => updateUrlParams(null),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, CLEAR_FILTERS_LABEL);
}
const NO_MONITORS_FOUND_HEADING = _i18n.i18n.translate('xpack.synthetics.overview.noMonitorsFoundHeading', {
  defaultMessage: 'No monitors found'
});
const NO_MONITORS_FOUND_CONTENT = _i18n.i18n.translate('xpack.synthetics.overview.noMonitorsFoundContent', {
  defaultMessage: 'Try refining your search.'
});
const CLEAR_FILTERS_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.overview.clearFilters', {
  defaultMessage: 'Clear filters'
});