"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorAsyncError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _state = require("../../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/monitor_errors/monitor_async_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorAsyncError = () => {
  const [isDismissed, setIsDismissed] = (0, _react.useState)(false);
  const {
    data: {
      syncErrors
    }
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  return syncErrors && syncErrors.length > 0 && !isDismissed ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorManagement.monitorSync.failure.title",
      defaultMessage: "Some monitors are not running correctly",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 11
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorManagement.monitorSync.failure.content",
    defaultMessage: "There was a problem running your monitors for one or more locations:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      maxHeight: 100,
      overflow: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, Object.values(syncErrors !== null && syncErrors !== void 0 ? syncErrors : {}).map(e => {
    var _locations$find, _e$error$status, _e$error, _e$error$reason, _e$error2;
    return /*#__PURE__*/_react.default.createElement("li", {
      key: e.locationId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 15
      }
    }, `${(_locations$find = locations.find(location => location.id === e.locationId)) === null || _locations$find === void 0 ? void 0 : _locations$find.label} - ${STATUS_LABEL}: ${(_e$error$status = (_e$error = e.error) === null || _e$error === void 0 ? void 0 : _e$error.status) !== null && _e$error$status !== void 0 ? _e$error$status : NOT_AVAILABLE_LABEL}; ${REASON_LABEL}: ${(_e$error$reason = (_e$error2 = e.error) === null || _e$error2 === void 0 ? void 0 : _e$error2.reason) !== null && _e$error$reason !== void 0 ? _e$error$reason : NOT_AVAILABLE_LABEL}`);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsMonitorAsyncErrorButton",
    onClick: () => setIsDismissed(true),
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, DISMISS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  })) : null;
};
exports.MonitorAsyncError = MonitorAsyncError;
const REASON_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorSync.failure.reasonLabel', {
  defaultMessage: 'Reason'
});
const STATUS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorSync.failure.statusLabel', {
  defaultMessage: 'Status'
});
const NOT_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorSync.failure.notAvailable', {
  defaultMessage: 'Not available'
});
const DISMISS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.monitorSync.failure.dismissLabel', {
  defaultMessage: 'Dismiss'
});