"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTestRunsSparkline = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../../hooks");
var _use_monitor_filters = require("../../hooks/use_monitor_filters");
var _use_monitor_query_filters = require("../../hooks/use_monitor_query_filters");
var labels = _interopRequireWildcard(require("../labels"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/monitor_stats/monitor_test_runs_sparkline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorTestRunsSparkline = () => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRange)(30, 'days');
  const filters = (0, _use_monitor_filters.useMonitorFilters)({});
  const queryFilter = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  const attributes = (0, _react.useMemo)(() => {
    return [{
      seriesType: 'area',
      time: {
        from,
        to
      },
      reportDefinitions: {
        'monitor.type': ['http', 'tcp', 'browser', 'icmp']
      },
      dataType: 'synthetics',
      selectedMetricField: 'total_test_runs',
      filters,
      name: labels.TEST_RUNS_LABEL,
      color: euiTheme.colors.vis.euiColorVis0,
      operationType: 'count'
    }];
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [from, euiTheme.colors.vis.euiColorVis0, to]);
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "monitor-test-runs-sparkline",
    reportType: "kpi-over-time",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    hideTicks: true,
    attributes: attributes,
    customHeight: '68px',
    dslFilters: queryFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  });
};
exports.MonitorTestRunsSparkline = MonitorTestRunsSparkline;