"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortMenu = exports.ORDER_BY_TITLE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/sort_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SortMenu = ({
  sortOptions,
  orderOptions,
  sortField
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const singleContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'singleContextMenuPopover'
  });
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsSortMenuButton",
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, sortField);
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    key: "sort_by_title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, SORT_BY_TITLE))), ...sortOptions.map(option => /*#__PURE__*/_react.default.createElement(ContextMenuItem, {
    option: option,
    onClosePopover: closePopover,
    key: option.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    key: "hr",
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    key: "order_by_title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, ORDER_BY_TITLE))), ...orderOptions.map(option => /*#__PURE__*/_react.default.createElement(ContextMenuItem, {
    option: option,
    onClosePopover: closePopover,
    key: option.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: singleContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    style: {
      minWidth: 160
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }));
};
exports.SortMenu = SortMenu;
const ContextMenuItem = ({
  option,
  onClosePopover
}) => {
  const getIconType = checked => {
    return checked ? 'check' : 'empty';
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    size: "s",
    key: option.value,
    icon: getIconType(option.checked),
    onClick: () => {
      onClosePopover();
      option.onClick();
    }
    // style={{
    //   marginRight: 24,
    // }}
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, option.label);
};
const SORT_BY_TITLE = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.sortBy.title', {
  defaultMessage: 'Sort by'
});
const ORDER_BY_TITLE = exports.ORDER_BY_TITLE = _i18n.i18n.translate('xpack.synthetics.overview.sortPopover.orderBy.title', {
  defaultMessage: 'Order'
});