"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DslRetentionTab = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _use_get_data_stream_statuses = require("../hooks/use_get_data_stream_statuses");
var _unprivileged = require("./unprivileged");
var _use_management_locator = require("./use_management_locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/data_retention/dsl_retention_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DslRetentionTab = () => {
  var _body;
  const {
    dataStreamStatuses = [],
    loading,
    error
  } = (0, _use_get_data_stream_statuses.useGetDataStreamStatuses)();
  if (error && ((_body = error.body) === null || _body === void 0 ? void 0 : _body.statusCode) === 403) return /*#__PURE__*/_react.default.createElement(_unprivileged.Unprivileged, {
    hideIlmMessage: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 12
    }
  });
  if (loading === false && dataStreamStatuses.length === 0) return /*#__PURE__*/_react.default.createElement(ErrorEmptyPrompt, {
    error: error === null || error === void 0 ? void 0 : error.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 12
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    rowHeader: "name",
    items: dataStreamStatuses,
    loading: loading === true,
    columns: DSL_RETENTION_COLUMNS,
    tableLayout: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
};
exports.DslRetentionTab = DslRetentionTab;
const DSL_RETENTION_COLUMNS = [{
  field: 'name',
  name: _i18n.i18n.translate('xpack.synthetics.dslRetention.columns.name', {
    defaultMessage: 'Dataset'
  }),
  render: (name, {
    dataStreamName
  }) => {
    if (!dataStreamName) {
      return name;
    }
    return /*#__PURE__*/_react.default.createElement(DataStreamLink, {
      dataStream: dataStreamName,
      name: name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 14
      }
    });
  }
}, {
  field: 'storageSize',
  name: _i18n.i18n.translate('xpack.synthetics.dslRetention.columns.currentSize', {
    defaultMessage: 'Current size'
  })
}, {
  field: 'lifecycle.data_retention',
  name: _i18n.i18n.translate('xpack.synthetics.dslRetention.columns.retentionPeriod', {
    defaultMessage: 'Retention period'
  })
}, {
  field: 'indexTemplateName',
  name: _i18n.i18n.translate('xpack.synthetics.dslRetention.columns.indexTemplateName', {
    defaultMessage: 'Index template'
  }),
  render: indexTemplateName => /*#__PURE__*/_react.default.createElement(IndexTemplateLabel, {
    indexTemplateName: indexTemplateName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  })
}];
function DataStreamLink({
  dataStream,
  name
}) {
  const templatePath = (0, _use_management_locator.useManagementLocator)(`/data_streams/${dataStream}`);
  if (templatePath === null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, name);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: templatePath,
    target: "_blank",
    "data-test-subj": `xpack.synthetics.dslRetention.indexTemplateLink.${name}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, name);
}
function IndexTemplateLabel({
  indexTemplateName
}) {
  const templatePath = (0, _use_management_locator.useManagementLocator)(`/templates/${indexTemplateName}`);
  if (templatePath === null) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indexTemplateName);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: templatePath,
    target: "_blank",
    "data-test-subj": `xpack.synthetics.dslRetention.indexTemplateLink.${indexTemplateName}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, indexTemplateName);
}
const ErrorEmptyPrompt = ({
  error
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "error",
  body: error !== null && error !== void 0 ? error : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "p",
    id: "xpack.synthetics.dslRetention.emptyErrorPrompt",
    defaultMessage: "No further error information available",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }),
  color: "danger",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    tagName: "h2",
    id: "xpack.synthetics.dslRetention.noData.heading",
    defaultMessage: "No data retention information found",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 3
  }
});