"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPaletteFlexItem = exports.ColorPalette = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _data_formatting = require("../common/network_data/data_formatting");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_objects/color_palette.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ColorPalette = ({
  label,
  mimeType,
  percent,
  value,
  loading,
  delta,
  hasAnyThresholdBreach,
  labelWidth = 40,
  valueWidth = 65
}) => {
  const getToolTipContent = () => {
    return _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.tooltip.label', {
      defaultMessage: 'Value is {deltaLabel} compared to steps in previous 24 hours.',
      values: {
        deltaLabel: Math.abs(delta) === 0 ? _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.tooltip.noChange', {
          defaultMessage: 'same'
        }) : delta > 0 ? _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.increased', {
          defaultMessage: '{delta}% higher',
          values: {
            delta
          }
        }) : _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.decreased', {
          defaultMessage: '{delta}% lower',
          values: {
            delta
          }
        })
      }
    });
  };
  const getColor = () => {
    if (Math.abs(delta) < 5) {
      return 'default';
    }
    return delta > 5 ? 'danger' : 'success';
  };
  const hasDelta = Math.abs(delta) > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: labelWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ColorPaletteFlexItem, {
    mimeType: mimeType,
    percent: isNaN(percent) ? 0 : percent,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: valueWidth,
      justifySelf: 'flex-end'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    style: {
      fontWeight: 'bold',
      whiteSpace: 'nowrap'
    },
    className: "eui-textRight",
    color: getColor(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, value)), hasAnyThresholdBreach && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 40
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: getToolTipContent(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, hasDelta ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: delta > 0 ? 'sortUp' : 'sortDown',
    size: "m",
    color: getColor(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minus",
    size: "m",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }))));
};
exports.ColorPalette = ColorPalette;
const ColorPaletteFlexItem = ({
  mimeType,
  percent,
  loading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [value, setVal] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    setTimeout(() => {
      if (value < percent) {
        setVal(value + 1);
      }
    }, 10);
  }, [percent, value]);
  (0, _react.useEffect)(() => {
    if (!loading) {
      setVal(0);
    }
  }, [loading]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      height: "20px",
      width: "100%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    style: {
      borderRadius: euiTheme.border.radius.medium,
      overflow: 'hidden'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      backgroundColor: euiTheme.colors.lightShade
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    style: {
      backgroundColor: _data_formatting.colourPalette[mimeType],
      height: 20,
      width: `${value}%`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  })));
};
exports.ColorPaletteFlexItem = ColorPaletteFlexItem;