"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingStatusColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../../common/constants");
var _translations = require("../../../../../../../../common/translations/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/simple/ping_list/columns/ping_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getPingStatusLabel = status => {
  return status === 'up' ? _translations.STATUS_UP_LABEL : _translations.STATUS_DOWN_LABEL;
};
const PingStatusColumn = ({
  pingStatus,
  item
}) => {
  const timeStamp = (0, _moment.default)(item['@timestamp']);
  let checkedTime = '';
  if ((0, _moment.default)().diff(timeStamp, 'd') > 1) {
    checkedTime = timeStamp.format('ll LTS');
  } else {
    checkedTime = timeStamp.format('LTS');
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `xpack.synthetics.pingList.ping-${item.docId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "eui-textCenter",
    color: pingStatus === _constants.STATUS.UP ? 'success' : 'danger',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, getPingStatusLabel(pingStatus)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.synthetics.pingList.recencyMessage', {
    values: {
      fromNow: checkedTime
    },
    defaultMessage: 'Checked {fromNow}',
    description: 'A string used to inform our users how long ago Heartbeat pinged the selected host.'
  })));
};
exports.PingStatusColumn = PingStatusColumn;