"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestNowModeFlyout = TestNowModeFlyout;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
var _test_now_mode = require("./test_now_mode");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/test_now_mode_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TestNowModeFlyout({
  name,
  testRun,
  onClose,
  onDone,
  inProgress,
  isPushing,
  errors,
  serviceError
}) {
  const flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: "push",
    size: "m",
    paddingSize: "m",
    maxWidth: "44%",
    "aria-labelledby": TEST_RESULT,
    onClose: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, name, "-", TEST_RESULTS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
    sectionName: "xpack.synthetics.monitorManagement.testNowFlyout.body",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, isPushing && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, PushingLabel, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 30
    }
  })), testRun ? /*#__PURE__*/_react.default.createElement(_test_now_mode.TestNowMode, {
    isPushing: isPushing,
    errors: errors,
    serviceError: serviceError,
    testRun: testRun,
    onDone: onDone,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }) : !isPushing && /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsTestNowModeFlyoutButton",
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, CLOSE_LABEL)));
  return testRun || inProgress ? flyout : null;
}
const TEST_RESULT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.testResult', {
  defaultMessage: 'Test result'
});
const TEST_RESULTS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.testResults', {
  defaultMessage: 'Test results'
});
const CLOSE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.closeButtonLabel', {
  defaultMessage: 'Close'
});
const PushingLabel = _i18n.i18n.translate('xpack.synthetics.testRun.pushing.description', {
  defaultMessage: 'Pushing the monitor to service...'
});