"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTestRunDetailsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _test_run_details_status = require("./components/test_run_details_status");
var _test_run_date = require("./components/test_run_date");
var _constants = require("../../../../../common/constants");
var _test_run_details = require("./test_run_details");
var _portals = require("../monitor_add_edit/portals");
var _monitor_details_location = require("../monitor_details/monitor_details_location");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_run_details/route_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getTestRunDetailsRoute = (history, syntheticsPath, baseTitle) => {
  return {
    title: _i18n.i18n.translate('xpack.synthetics.testRunDetailsRoute.title', {
      defaultMessage: 'Test run details | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.TEST_RUN_DETAILS_ROUTE,
    component: _test_run_details.TestRunDetails,
    dataTestSubj: 'syntheticsMonitorTestRunDetailsPage',
    pageHeader: {
      breadcrumbs: [{
        text: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
          node: _portals.MonitorDetailsLinkPortalNode,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 37,
            columnNumber: 17
          }
        })
      }],
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.testRunDetailsRoute.page.title",
        defaultMessage: "Test run details",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_test_run_date.TestRunDate, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 24
        }
      }), /*#__PURE__*/_react.default.createElement(_test_run_details_status.TestRunDetailsStatus, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 41
        }
      }), /*#__PURE__*/_react.default.createElement(_monitor_details_location.MonitorDetailsLocation, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 67
        }
      })]
    }
  };
};
exports.getTestRunDetailsRoute = getTestRunDetailsRoute;