"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorById = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _state = require("../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorById = configId => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const monitor = (0, _reactRedux.useSelector)(_state.selectSyntheticsMonitor);
  (0, _react.useEffect)(() => {
    if (configId) {
      dispatch(_state.getMonitorAction.get({
        monitorId: configId
      }));
    }
  }, [configId, dispatch]);
  return (monitor === null || monitor === void 0 ? void 0 : monitor.config_id) === configId ? monitor : undefined;
};
exports.useMonitorById = useMonitorById;