"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCertsList = void 0;
var _constants = require("../../../../../common/constants");
var _api_service = require("../../../../utils/api_service/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCertsList = async queryParams => {
  const {
    pageIndex,
    size,
    search,
    sortBy,
    direction
  } = queryParams;
  const result = await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.CERTS, {
    pageIndex,
    size,
    search,
    sortBy,
    direction
  });
  return result.data;
};
exports.getCertsList = getCertsList;