"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeSettingsObjectType = exports.uptimeSettingsObjectId = exports.syntheticsSettingsObjectType = exports.syntheticsSettingsObjectId = exports.syntheticsSettings = exports.setSyntheticsDynamicSettings = exports.getSyntheticsDynamicSettings = void 0;
var _i18n = require("@kbn/i18n");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _dynamic_settings = require("../routes/settings/dynamic_settings");
var _settings = require("../constants/settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uptimeSettingsObjectType = exports.uptimeSettingsObjectType = 'uptime-dynamic-settings';
const uptimeSettingsObjectId = exports.uptimeSettingsObjectId = 'uptime-dynamic-settings-singleton';
const syntheticsSettingsObjectType = exports.syntheticsSettingsObjectType = 'synthetics-dynamic-settings';
const syntheticsSettingsObjectId = exports.syntheticsSettingsObjectId = 'synthetics-dynamic-settings-singleton';
const syntheticsSettings = exports.syntheticsSettings = {
  name: syntheticsSettingsObjectType,
  hidden: false,
  namespaceType: 'single',
  mappings: {
    dynamic: false,
    properties: {}
  },
  management: {
    importableAndExportable: true,
    icon: 'uptimeApp',
    getTitle: () => _i18n.i18n.translate('xpack.synthetics.settings.index', {
      defaultMessage: 'Synthetics settings'
    })
  }
};
const getSyntheticsDynamicSettings = async client => {
  try {
    var _obj$attributes;
    const obj = await client.get(syntheticsSettingsObjectType, syntheticsSettingsObjectId);
    return (0, _dynamic_settings.fromSettingsAttribute)((_obj$attributes = obj === null || obj === void 0 ? void 0 : obj.attributes) !== null && _obj$attributes !== void 0 ? _obj$attributes : _settings.DYNAMIC_SETTINGS_DEFAULT_ATTRIBUTES);
  } catch (getErr) {
    if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(getErr)) {
      // If the object doesn't exist, check to see if uptime settings exist
      return getUptimeDynamicSettings(client);
    }
    throw getErr;
  }
};
exports.getSyntheticsDynamicSettings = getSyntheticsDynamicSettings;
const setSyntheticsDynamicSettings = async (client, settings) => {
  const settingsObject = await client.create(syntheticsSettingsObjectType, settings, {
    id: syntheticsSettingsObjectId,
    overwrite: true
  });
  return settingsObject.attributes;
};
exports.setSyntheticsDynamicSettings = setSyntheticsDynamicSettings;
const getUptimeDynamicSettings = async client => {
  try {
    var _obj$attributes2;
    const obj = await client.get(uptimeSettingsObjectType, uptimeSettingsObjectId);
    return (_obj$attributes2 = obj === null || obj === void 0 ? void 0 : obj.attributes) !== null && _obj$attributes2 !== void 0 ? _obj$attributes2 : _settings.DYNAMIC_SETTINGS_DEFAULT_ATTRIBUTES;
  } catch (getErr) {
    return _settings.DYNAMIC_SETTINGS_DEFAULT_ATTRIBUTES;
  }
};