"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initSyntheticsServer = void 0;
var _tls_rule = require("./alert_rules/tls_rule/tls_rule");
var _monitor_status_rule = require("./alert_rules/status_rule/monitor_status_rule");
var _create_route_with_auth = require("./routes/create_route_with_auth");
var _synthetics_route_wrapper = require("./synthetics_route_wrapper");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initSyntheticsServer = (server, syntheticsMonitorClient, plugins, ruleDataClient) => {
  const {
    router
  } = server;
  _routes.syntheticsAppRestApiRoutes.forEach(route => {
    const {
      method,
      options,
      handler,
      validate,
      path,
      security
    } = (0, _synthetics_route_wrapper.syntheticsRouteWrapper)((0, _create_route_with_auth.createSyntheticsRouteWithAuth)(route), server, syntheticsMonitorClient);
    const routeDefinition = {
      path,
      validate,
      security,
      options
    };
    switch (method) {
      case 'GET':
        router.get(routeDefinition, handler);
        break;
      case 'POST':
        router.post(routeDefinition, handler);
        break;
      case 'PUT':
        router.put(routeDefinition, handler);
        break;
      case 'DELETE':
        router.delete(routeDefinition, handler);
        break;
      default:
        throw new Error(`Handler for method ${method} is not defined`);
    }
  });
  _routes.syntheticsAppPublicRestApiRoutes.forEach(route => {
    const {
      method,
      options,
      handler,
      validate,
      path,
      validation,
      security
    } = (0, _synthetics_route_wrapper.syntheticsRouteWrapper)((0, _create_route_with_auth.createSyntheticsRouteWithAuth)(route), server, syntheticsMonitorClient);
    const routeDefinition = {
      path,
      validate,
      options
    };
    switch (method) {
      case 'GET':
        router.versioned.get({
          access: 'public',
          security,
          path: routeDefinition.path
        }).addVersion({
          version: '2023-10-31',
          validate: validation !== null && validation !== void 0 ? validation : false
        }, handler);
        break;
      case 'PUT':
        router.versioned.put({
          access: 'public',
          security,
          path: routeDefinition.path
        }).addVersion({
          version: '2023-10-31',
          validate: validation !== null && validation !== void 0 ? validation : false
        }, handler);
        break;
      case 'POST':
        router.versioned.post({
          access: 'public',
          security,
          path: routeDefinition.path
        }).addVersion({
          version: '2023-10-31',
          validate: validation !== null && validation !== void 0 ? validation : false
        }, handler);
        break;
      case 'DELETE':
        router.versioned.delete({
          access: 'public',
          path: routeDefinition.path,
          security,
          options: {
            tags: options === null || options === void 0 ? void 0 : options.tags
          }
        }).addVersion({
          version: '2023-10-31',
          validate: validation !== null && validation !== void 0 ? validation : false
        }, handler);
        break;
      default:
        throw new Error(`Handler for method ${method} is not defined`);
    }
  });
  (0, _monitor_status_rule.registerSyntheticsStatusCheckRule)(server, plugins, syntheticsMonitorClient);
  (0, _tls_rule.registerSyntheticsTLSCheckRule)(server, plugins, syntheticsMonitorClient);
};
exports.initSyntheticsServer = initSyntheticsServer;