"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricsAggregators = createMetricsAggregators;
exports.createMetricsStream = createMetricsStream;
var _rxjs = require("rxjs");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _wrapped_logger = require("../lib/wrapped_logger");
var _task_events = require("../task_events");
var _task_claim_metrics_aggregator = require("./task_claim_metrics_aggregator");
var _create_aggregator = require("./create_aggregator");
var _task_run_metrics_aggregator = require("./task_run_metrics_aggregator");
var _task_overdue_metrics_aggregator = require("./task_overdue_metrics_aggregator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createMetricsAggregators({
  config,
  reset$,
  logger,
  taskPollingLifecycle,
  taskManagerMetricsCollector
}) {
  const aggregators = [];
  const debugLogger = (0, _wrapped_logger.createWrappedLogger)({
    logger,
    tags: ['metrics-debugger']
  });
  if (taskPollingLifecycle) {
    aggregators.push((0, _create_aggregator.createAggregator)({
      key: 'task_claim',
      events$: taskPollingLifecycle.events,
      config,
      reset$,
      eventFilter: event => (0, _task_events.isTaskPollingCycleEvent)(event),
      metricsAggregator: new _task_claim_metrics_aggregator.TaskClaimMetricsAggregator()
    }), (0, _create_aggregator.createAggregator)({
      key: 'task_run',
      events$: taskPollingLifecycle.events,
      config,
      logger: debugLogger,
      reset$,
      eventFilter: event => (0, _task_events.isTaskRunEvent)(event) || (0, _task_events.isTaskManagerStatEvent)(event),
      metricsAggregator: new _task_run_metrics_aggregator.TaskRunMetricsAggregator(debugLogger)
    }));
  }
  if (taskManagerMetricsCollector) {
    aggregators.push((0, _create_aggregator.createAggregator)({
      key: 'task_overdue',
      events$: taskManagerMetricsCollector.events,
      config,
      eventFilter: event => (0, _task_events.isTaskManagerMetricEvent)(event),
      metricsAggregator: new _task_overdue_metrics_aggregator.TaskOverdueMetricsAggregator()
    }));
  }
  return (0, _rxjs.merge)(...aggregators);
}
function createMetricsStream(provider$) {
  const initialMetrics = {
    last_update: new Date().toISOString(),
    metrics: {}
  };
  return (0, _rxjs.merge)(
  // emit the initial metrics
  (0, _rxjs.of)(initialMetrics),
  // emit updated metrics whenever a provider updates a specific key on the stats
  provider$.pipe((0, _rxjs.map)(({
    key,
    value
  }) => {
    return {
      value: {
        timestamp: new Date().toISOString(),
        value
      },
      key
    };
  }), (0, _rxjs.scan)((metrics, {
    key,
    value
  }) => {
    // incrementally merge stats as they come in
    (0, _saferLodashSet.set)(metrics.metrics, key, value);
    metrics.last_update = new Date().toISOString();
    return metrics;
  }, initialMetrics)));
}