"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FIELD = exports.COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT = exports.COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = void 0;
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _accessibility = require("../../../../common/utils/accessibility");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _translations = require("./translations");
var _with_copy_to_clipboard = require("../../clipboard/with_copy_to_clipboard");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/timelines/public/components/hover_actions/actions/copy.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIELD = exports.FIELD = _i18n.i18n.translate('xpack.timelines.hoverActions.fieldLabel', {
  defaultMessage: 'Field'
});
const COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT = exports.COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT = 'c';
const COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = exports.COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME = 'copy-to-clipboard';
const CopyButton = exports.default = /*#__PURE__*/_react.default.memo(({
  Component,
  field,
  isHoverAction,
  onClick,
  keyboardEvent,
  ownFocus,
  value
}) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const panelRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!ownFocus) {
      return;
    }
    if ((keyboardEvent === null || keyboardEvent === void 0 ? void 0 : keyboardEvent.key) === COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT) {
      var _panelRef$current;
      (0, _accessibility.stopPropagationAndPreventDefault)(keyboardEvent);
      const copyToClipboardButton = (_panelRef$current = panelRef.current) === null || _panelRef$current === void 0 ? void 0 : _panelRef$current.querySelector(`.${COPY_TO_CLIPBOARD_BUTTON_CLASS_NAME}`);
      if (copyToClipboardButton != null) {
        copyToClipboardButton.click();
      }
      if (onClick != null) {
        onClick();
      }
    }
  }, [onClick, keyboardEvent, ownFocus]);
  const text = (0, _react.useMemo)(() => `${field}${value != null ? `: "${value}"` : ''}`, [field, value]);
  const handleOnClick = (0, _react.useCallback)(() => {
    const isSuccess = (0, _copyToClipboard.default)(text, {
      debug: true
    });
    if (onClick != null) {
      onClick();
    }
    if (isSuccess) {
      addSuccess((0, _translations.SUCCESS_TOAST_TITLE)(field), {
        toastLifeTimeMs: 800
      });
    }
  }, [addSuccess, field, onClick, text]);
  return Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": _translations.COPY_TO_CLIPBOARD,
    "data-test-subj": "copy-to-clipboard",
    icon: "copy",
    iconType: "copy",
    onClick: handleOnClick,
    title: _translations.COPY_TO_CLIPBOARD,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, _translations.COPY_TO_CLIPBOARD) : /*#__PURE__*/_react.default.createElement("div", {
    ref: panelRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_with_copy_to_clipboard.WithCopyToClipboard, {
    "data-test-subj": "copy-to-clipboard",
    isHoverAction: isHoverAction,
    keyboardShortcut: ownFocus ? COPY_TO_CLIPBOARD_KEYBOARD_SHORTCUT : '',
    text: text,
    titleSummary: FIELD,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }));
});
CopyButton.displayName = 'CopyButton';

// eslint-disable-next-line import/no-default-export