"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Updated = exports.LastUpdatedAt = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/timelines/public/components/last_updated/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Updated = exports.Updated = /*#__PURE__*/_react.default.memo(({
  date,
  prefix,
  updatedAt
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, prefix, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
  "data-test-subj": "last-updated-at-date",
  key: `formatedRelative-${date}`,
  value: new Date(updatedAt),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 25,
    columnNumber: 9
  }
})));
Updated.displayName = 'Updated';
const prefix = ` ${i18n.UPDATED} `;
const LastUpdatedAt = exports.default = exports.LastUpdatedAt = /*#__PURE__*/_react.default.memo(({
  compact = false,
  updatedAt,
  showUpdating = false
}) => {
  const [date, setDate] = (0, _react.useState)(Date.now());
  function tick() {
    setDate(Date.now());
  }
  (0, _react.useEffect)(() => {
    const timerID = setInterval(() => tick(), 10000);
    return () => {
      clearInterval(timerID);
    };
  }, []);
  const updateText = (0, _react.useMemo)(() => {
    if (showUpdating) {
      return /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 16
        }
      }, " ", i18n.UPDATING);
    }
    if (!compact) {
      return /*#__PURE__*/_react.default.createElement(Updated, {
        date: date,
        prefix: prefix,
        updatedAt: updatedAt,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 16
        }
      });
    }
    return null;
  }, [compact, date, showUpdating, updatedAt]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "timeline-stream-tool-tip",
    content: /*#__PURE__*/_react.default.createElement(Updated, {
      date: date,
      prefix: prefix,
      updatedAt: updatedAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 18
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, updateText));
});
LastUpdatedAt.displayName = 'LastUpdatedAt';

// eslint-disable-next-line import/no-default-export