"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToastNotificationText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _app_dependencies = require("../app_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/components/toast_notification_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_SIMPLE_MESSAGE_LENGTH = 140;
const ToastNotificationText = ({
  text,
  previewTextLength,
  inline = false,
  forceModal = false
}) => {
  const {
    overlays,
    ...startServices
  } = (0, _app_dependencies.useAppDependencies)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!forceModal && typeof text === 'string' && text.length <= MAX_SIMPLE_MESSAGE_LENGTH) {
    return text;
  }
  if (!forceModal && typeof text === 'object' && text !== null && typeof text.message === 'string' && text.message.length <= MAX_SIMPLE_MESSAGE_LENGTH) {
    return text.message;
  }
  const unformattedText = typeof text === 'object' && text !== null && text.message ? text.message : text;
  const formattedText = typeof unformattedText === 'object' ? JSON.stringify(text, null, 2) : unformattedText;
  const textLength = previewTextLength !== null && previewTextLength !== void 0 ? previewTextLength : 140;
  const previewText = `${formattedText.substring(0, textLength)}${formattedText.length > textLength ? ' ...' : ''}`;
  const openModal = () => {
    const modal = overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "aria-labelledby": modalTitleId,
      onClose: () => modal.close(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.transform.toastText.modalTitle', {
      defaultMessage: 'Error details'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      fontSize: "m",
      paddingSize: "s",
      isCopyable: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }, formattedText)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => modal.close(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.transform.toastText.closeModalButtonText', {
      defaultMessage: 'Close'
    })))), startServices));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !inline && /*#__PURE__*/_react.default.createElement("pre", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 19
    }
  }, previewText), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: openModal,
    css: inline ? {
      blockSize: 0
    } : {},
    size: inline ? 's' : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.transform.toastText.openModalButtonText', {
    defaultMessage: 'View details'
  })));
};
exports.ToastNotificationText = ToastNotificationText;