"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteTransforms = exports.useDeleteIndexAndTargetIndex = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _constants = require("../../../common/constants");
var _errors = require("../../../common/utils/errors");
var _app_dependencies = require("../app_dependencies");
var _components = require("../components");
var _use_transform_capabilities = require("./use_transform_capabilities");
var _use_data_view_exists = require("./use_data_view_exists");
var _use_refresh_transform_list = require("./use_refresh_transform_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/hooks/use_delete_transform.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useDeleteIndexAndTargetIndex = items => {
  var _capabilities$savedOb, _capabilities$indexPa;
  const {
    application: {
      capabilities
    }
  } = (0, _app_dependencies.useAppDependencies)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    canDeleteIndex: userCanDeleteIndex
  } = (0, _use_transform_capabilities.useTransformCapabilities)();
  const userCanDeleteDataView = ((_capabilities$savedOb = capabilities.savedObjectsManagement) === null || _capabilities$savedOb === void 0 ? void 0 : _capabilities$savedOb.delete) === true || ((_capabilities$indexPa = capabilities.indexPatterns) === null || _capabilities$indexPa === void 0 ? void 0 : _capabilities$indexPa.save) === true;
  const [deleteDestIndex, setDeleteDestIndex] = (0, _react.useState)(true);
  const [deleteDataView, setDeleteDataView] = (0, _react.useState)(userCanDeleteDataView);
  const toggleDeleteIndex = (0, _react.useCallback)(() => setDeleteDestIndex(!deleteDestIndex), [deleteDestIndex]);
  const toggleDeleteDataView = (0, _react.useCallback)(() => setDeleteDataView(!deleteDataView), [deleteDataView]);
  const {
    error: dataViewExistsError,
    data: dataViewExists = items.length !== 1
  } = (0, _use_data_view_exists.useDataViewExists)(items);
  (0, _react.useEffect)(() => {
    if (dataViewExistsError !== null && items.length === 1) {
      const config = items[0].config;
      const indexName = config.dest.index;
      toastNotifications.addDanger(_i18n.i18n.translate('xpack.transform.deleteTransform.errorWithCheckingIfDataViewExistsNotificationErrorMessage', {
        defaultMessage: 'An error occurred checking if data view {dataView} exists: {error}',
        values: {
          dataView: indexName,
          error: (0, _mlErrorUtils.extractErrorMessage)(dataViewExistsError)
        }
      }));
    }
    // custom comparison
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataViewExistsError]);
  return {
    userCanDeleteIndex,
    userCanDeleteDataView,
    deleteDestIndex,
    dataViewExists,
    deleteDataView,
    toggleDeleteIndex,
    toggleDeleteDataView
  };
};
exports.useDeleteIndexAndTargetIndex = useDeleteIndexAndTargetIndex;
const useDeleteTransforms = () => {
  const {
    http,
    ...startServices
  } = (0, _app_dependencies.useAppDependencies)();
  const refreshTransformList = (0, _use_refresh_transform_list.useRefreshTransformList)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const mutation = (0, _reactQuery.useMutation)({
    mutationFn: reqBody => http.post((0, _constants.addInternalBasePath)('delete_transforms'), {
      body: JSON.stringify(reqBody),
      version: '1'
    }),
    onError: error => toastNotifications.addDanger({
      title: _i18n.i18n.translate('xpack.transform.transformList.deleteTransformGenericErrorMessage', {
        defaultMessage: 'An error occurred calling the API endpoint to delete transforms.'
      }),
      text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
        previewTextLength: 50,
        text: (0, _errors.getErrorMessage)(error),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 11
        }
      }), startServices)
    }),
    onSuccess: results => {
      for (const transformId in results) {
        // hasOwnProperty check to ensure only properties on object itself, and not its prototypes
        if (Object.hasOwn(results, transformId)) {
          var _status$transformDele, _status$destIndexDele, _status$destDataViewD;
          const status = results[transformId];
          const destinationIndex = status.destinationIndex;
          if ((_status$transformDele = status.transformDeleted) !== null && _status$transformDele !== void 0 && _status$transformDele.error) {
            const error = status.transformDeleted.error.reason;
            toastNotifications.addDanger({
              title: _i18n.i18n.translate('xpack.transform.transformList.deleteTransformErrorMessage', {
                defaultMessage: 'An error occurred deleting the transform {transformId}',
                values: {
                  transformId
                }
              }),
              text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
                previewTextLength: 50,
                text: error,
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 125,
                  columnNumber: 17
                }
              }), startServices)
            });
          }
          if ((_status$destIndexDele = status.destIndexDeleted) !== null && _status$destIndexDele !== void 0 && _status$destIndexDele.error) {
            const error = status.destIndexDeleted.error.reason;
            toastNotifications.addDanger({
              title: _i18n.i18n.translate('xpack.transform.deleteTransform.deleteAnalyticsWithIndexErrorMessage', {
                defaultMessage: 'An error occurred deleting destination index {destinationIndex}',
                values: {
                  destinationIndex
                }
              }),
              text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
                previewTextLength: 50,
                text: error,
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 142,
                  columnNumber: 17
                }
              }), startServices)
            });
          }
          if ((_status$destDataViewD = status.destDataViewDeleted) !== null && _status$destDataViewD !== void 0 && _status$destDataViewD.error) {
            const error = (0, _mlErrorUtils.extractErrorMessage)(status.destDataViewDeleted.error);
            toastNotifications.addDanger({
              title: _i18n.i18n.translate('xpack.transform.deleteTransform.deleteAnalyticsWithDataViewErrorMessage', {
                defaultMessage: 'An error occurred deleting data view {destinationIndex}',
                values: {
                  destinationIndex
                }
              }),
              text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
                previewTextLength: 50,
                text: error,
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 159,
                  columnNumber: 17
                }
              }), startServices)
            });
          }
        }
      }
      refreshTransformList();
    }
  });
  return mutation.mutate;
};
exports.useDeleteTransforms = useDeleteTransforms;