"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PivotFunctionForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_documentation_links = require("../../../../hooks/use_documentation_links");
var _advanced_pivot_editor = require("../advanced_pivot_editor");
var _advanced_pivot_editor_switch = require("../advanced_pivot_editor_switch");
var _pivot_configuration = require("../pivot_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/step_define/pivot_function_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const advancedEditorsSidebarWidth = '220px';
const PivotFunctionForm = ({
  applyPivotChangesHandler,
  copyToClipboardPivot,
  copyToClipboardPivotDescription,
  stepDefineForm
}) => {
  const {
    esTransformPivot
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const {
    isAdvancedPivotEditorEnabled,
    isAdvancedPivotEditorApplyButtonEnabled
  } = stepDefineForm.advancedPivotEditor.state;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, !isAdvancedPivotEditorEnabled && /*#__PURE__*/_react.default.createElement(_pivot_configuration.PivotConfiguration, (0, _extends2.default)({}, stepDefineForm.pivotConfig, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 43
    }
  })), isAdvancedPivotEditorEnabled && /*#__PURE__*/_react.default.createElement(_advanced_pivot_editor.AdvancedPivotEditor, (0, _extends2.default)({}, stepDefineForm.advancedPivotEditor, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_advanced_pivot_editor_switch.AdvancedPivotEditorSwitch, (0, _extends2.default)({}, stepDefineForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: copyToClipboardPivotDescription,
    textToCopy: copyToClipboardPivot,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 19
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": copyToClipboardPivotDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 23
    }
  })))))), isAdvancedPivotEditorEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: advancedEditorsSidebarWidth
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorHelpText', {
    defaultMessage: 'The advanced editor allows you to edit the pivot configuration of the transform.'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: esTransformPivot,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorHelpTextLink', {
    defaultMessage: 'Learn more about available options.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    style: {
      width: 'fit-content'
    },
    size: "s",
    fill: true,
    onClick: applyPivotChangesHandler,
    disabled: !isAdvancedPivotEditorApplyButtonEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorApplyButtonText', {
    defaultMessage: 'Apply changes'
  }))))));
};
exports.PivotFunctionForm = PivotFunctionForm;