"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDefineSummary = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _app_dependencies = require("../../../../app_dependencies");
var _common = require("../../../../common");
var _use_transform_config_data = require("../../../../hooks/use_transform_config_data");
var _aggregation_list = require("../aggregation_list");
var _group_by_list = require("../group_by_list");
var _constants = require("../../../../../../common/constants");
var _types = require("./common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/step_define/step_define_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StepDefineSummary = ({
  formState: {
    isDatePickerApplyEnabled,
    timeRangeMs,
    runtimeMappings,
    searchString,
    searchQuery,
    groupByList,
    aggList,
    transformFunction,
    previewRequest: partialPreviewRequest,
    validationStatus
  },
  searchItems
}) => {
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const transformConfigQuery = (0, _common.getTransformConfigQuery)(searchQuery);
  const previewRequest = (0, _common.getPreviewTransformRequestBody)(searchItems.dataView, transformConfigQuery, partialPreviewRequest, runtimeMappings, isDatePickerApplyEnabled ? timeRangeMs : undefined);
  const pivotPreviewProps = (0, _use_transform_config_data.useTransformConfigData)(searchItems.dataView, transformConfigQuery, validationStatus, partialPreviewRequest, runtimeMappings, isDatePickerApplyEnabled ? timeRangeMs : undefined);
  const isModifiedQuery = typeof searchString === 'undefined' && !(0, _mlQueryUtils.isDefaultQuery)(transformConfigQuery) && !(0, _mlQueryUtils.isMatchAllQuery)(transformConfigQuery);
  let uniqueKeys = [];
  let sortField = '';
  if ((0, _types.isLatestPartialRequest)(previewRequest)) {
    uniqueKeys = previewRequest.latest.unique_key;
    sortField = previewRequest.latest.sort;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformStepDefineSummary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, searchItems.savedSearch === undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineSummary.dataViewLabel', {
      defaultMessage: 'Data view'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  }, searchItems.dataView.getIndexPattern())), isDatePickerApplyEnabled && timeRangeMs && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineSummary.timeRangeLabel', {
      defaultMessage: 'Time range'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 17
    }
  }, (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(timeRangeMs.from), " -", ' ', (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)(timeRangeMs.to))), typeof searchString === 'string' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineSummary.queryLabel', {
      defaultMessage: 'Query'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }, searchString)), isModifiedQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineSummary.queryCodeBlockLabel', {
      defaultMessage: 'Query'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "js",
    fontSize: "s",
    paddingSize: "s",
    color: "light",
    overflowHeight: 300,
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 17
    }
  }, JSON.stringify(transformConfigQuery, null, 2)))), searchItems.savedSearch !== undefined && searchItems.savedSearch.id !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineSummary.discoverSessionLabel', {
      defaultMessage: 'Discover session'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, searchItems.savedSearch.title)), transformFunction === _constants.TRANSFORM_FUNCTION.PIVOT ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineSummary.groupByLabel', {
      defaultMessage: 'Group by'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_group_by_list.GroupByListSummary, {
    list: groupByList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineSummary.aggregationsLabel', {
      defaultMessage: 'Aggregations'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_aggregation_list.AggListSummary, {
    list: aggList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.stepDefineForm.uniqueKeysLabel",
      defaultMessage: "Unique keys",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, uniqueKeys.map(k => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    key: k,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 19
    }
  }, k)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.stepDefineForm.sortLabel",
      defaultMessage: "Sort field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }, sortField))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_mlDataGrid.DataGrid, (0, _extends2.default)({}, pivotPreviewProps, {
    copyToClipboard: (0, _common.getTransformPreviewDevConsoleStatement)(previewRequest),
    copyToClipboardDescription: _i18n.i18n.translate('xpack.transform.pivotPreview.copyClipboardTooltip', {
      defaultMessage: 'Copy Dev Console statement of the transform preview to the clipboard.'
    }),
    dataTestSubj: "transformPivotPreview",
    title: _i18n.i18n.translate('xpack.transform.pivotPreview.transformPreviewTitle', {
      defaultMessage: 'Transform preview'
    }),
    toastNotifications: toastNotifications,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }))));
};
exports.StepDefineSummary = StepDefineSummary;