"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDetailsSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/step_details/step_details_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StepDetailsSummary = exports.StepDetailsSummary = /*#__PURE__*/_react.default.memo(props => {
  const {
    continuousModeDateField,
    createDataView,
    isContinuousModeEnabled,
    isRetentionPolicyEnabled,
    retentionPolicyDateField,
    retentionPolicyMaxAge,
    transformId,
    transformDescription,
    transformFrequency,
    transformSettingsMaxPageSearchSize,
    transformSettingsNumFailureRetries,
    destinationIndex,
    destinationIngestPipeline,
    touched,
    dataViewTimeField
  } = props;
  if (touched === false) {
    return null;
  }
  const destinationIndexHelpText = createDataView ? _i18n.i18n.translate('xpack.transform.stepDetailsSummary.createDataViewMessage', {
    defaultMessage: 'A Kibana data view will be created for this transform.'
  }) : '';
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformStepDetailsSummary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.transformIdLabel', {
      defaultMessage: 'Transform ID'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, transformId)), transformDescription !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.transformDescriptionLabel', {
      defaultMessage: 'Transform description'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, transformDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: destinationIndexHelpText,
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.destinationIndexLabel', {
      defaultMessage: 'Destination index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, destinationIndex)), createDataView && dataViewTimeField !== undefined && dataViewTimeField !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.dataViewTimeFieldLabel', {
      defaultMessage: 'Kibana data view time field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, dataViewTimeField)), destinationIngestPipeline !== undefined && destinationIngestPipeline !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.destinationIngestPipelineLabel', {
      defaultMessage: 'Destination ingest pipeline'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, destinationIngestPipeline)), isContinuousModeEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.continuousModeDateFieldLabel', {
      defaultMessage: 'Continuous mode date field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, continuousModeDateField)), isRetentionPolicyEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.retentionPolicyDateFieldLabel', {
      defaultMessage: 'Retention policy date field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, retentionPolicyDateField)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.retentionPolicyMaxAgeLabel', {
      defaultMessage: 'Retention policy max age'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, retentionPolicyMaxAge))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": "transformWizardAccordionAdvancedSettingsSummary",
    id: "transformWizardAccordionAdvancedSettingsSummary",
    buttonContent: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.advancedSettingsAccordionButtonContent', {
      defaultMessage: 'Advanced settings'
    }),
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": 'transformWizardAdvancedSettingsFrequencyLabel',
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.frequencyLabel', {
      defaultMessage: 'Frequency'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, transformFrequency)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": 'transformWizardAdvancedSettingsMaxPageSearchSizeLabel',
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.maxPageSearchSizeLabel', {
      defaultMessage: 'Maximum page search size'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, transformSettingsMaxPageSearchSize)), typeof transformSettingsNumFailureRetries === 'number' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": 'transformWizardAdvancedSettingsNumFailureRetriesLabel',
    label: _i18n.i18n.translate('xpack.transform.stepDetailsSummary.numFailureRetriesLabel', {
      defaultMessage: 'Number of retries'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, transformSettingsNumFailureRetries)) : null));
});