"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformIngestPipeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _edit_transform_flyout_state = require("../state_management/edit_transform_flyout_state");
var _form_field = require("../state_management/selectors/form_field");
var _edit_transform_flyout_form_text_input = require("./edit_transform_flyout_form_text_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/edit_transform/components/edit_transform_ingest_pipeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ingestPipelineLabel = _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormDestinationIngestPipelineLabel', {
  defaultMessage: 'Ingest Pipeline'
});
const EditTransformIngestPipeline = () => {
  var _esIngestPipelinesDat;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    errorMessages,
    value
  } = (0, _form_field.useFormField)('destinationIngestPipeline');
  const {
    setFormField
  } = (0, _edit_transform_flyout_state.useEditTransformFlyoutActions)();
  const {
    data: esIngestPipelinesData,
    isLoading
  } = (0, _hooks.useGetEsIngestPipelines)();
  const ingestPipelineNames = (_esIngestPipelinesDat = esIngestPipelinesData === null || esIngestPipelinesData === void 0 ? void 0 : esIngestPipelinesData.map(({
    name
  }) => name)) !== null && _esIngestPipelinesDat !== void 0 ? _esIngestPipelinesDat : [];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null,
  // If the list of ingest pipelines is not available
  // gracefully defaults to text input
  ingestPipelineNames.length > 0 || isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: ingestPipelineLabel,
    isInvalid: errorMessages.length > 0,
    error: errorMessages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "100%",
    height: euiTheme.size.xxl,
    isLoading: isLoading,
    contentAriaLabel: ingestPipelineLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "transformEditFlyoutDestinationIngestPipelineFieldSelect",
    "aria-label": _i18n.i18n.translate('xpack.transform.stepDetailsForm.editFlyoutFormDestinationIngestPipelineFieldSelectAriaLabel', {
      defaultMessage: 'Select an ingest pipeline'
    }),
    placeholder: _i18n.i18n.translate('xpack.transform.stepDetailsForm.editFlyoutFormDestinationIngestPipelineFieldSelectPlaceholder', {
      defaultMessage: 'Select an ingest pipeline'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: ingestPipelineNames.map(label => ({
      label
    })),
    selectedOptions: [{
      label: value
    }],
    onChange: o => {
      var _o$0$label, _o$;
      return setFormField({
        field: 'destinationIngestPipeline',
        value: (_o$0$label = (_o$ = o[0]) === null || _o$ === void 0 ? void 0 : _o$.label) !== null && _o$0$label !== void 0 ? _o$0$label : ''
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
    field: "destinationIngestPipeline",
    label: ingestPipelineLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }));
};
exports.EditTransformIngestPipeline = EditTransformIngestPipeline;