"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetActionModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
var _managed_transforms_callout = require("../managed_transforms_callout/managed_transforms_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_reset/reset_action_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResetActionModal = ({
  closeModal,
  resetAndCloseModal,
  items,
  shouldForceReset
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const hasManagedTransforms = (0, _react.useMemo)(() => items.some(t => (0, _managed_transforms_utils.isManagedTransform)(t)), [items]);
  const isBulkAction = items.length > 1;
  const bulkResetModalTitle = _i18n.i18n.translate('xpack.transform.transformList.bulkResetModalTitle', {
    defaultMessage: 'Reset {count} {count, plural, one {transform} other {transforms}}?',
    values: {
      count: items.length
    }
  });
  const resetModalTitle = _i18n.i18n.translate('xpack.transform.transformList.resetModalTitle', {
    defaultMessage: 'Reset {transformId}?',
    values: {
      transformId: items[0] && items[0].config.id
    }
  });
  const bulkResetModalContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, hasManagedTransforms ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_transforms_callout.ManagedTransformsWarningCallout, {
    count: items.length,
    action: _i18n.i18n.translate('xpack.transform.transformList.resetManagedTransformDescription', {
      defaultMessage: 'resetting'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  })) : null));
  const resetModalContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, hasManagedTransforms ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managed_transforms_callout.ManagedTransformsWarningCallout, {
    count: 1,
    action: _i18n.i18n.translate('xpack.transform.transformList.resetManagedTransformDescription', {
      defaultMessage: 'resetting'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  })) : null));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "transformResetModal",
    "aria-labelledby": modalTitleId,
    title: isBulkAction === true ? bulkResetModalTitle : resetModalTitle,
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeModal,
    onConfirm: resetAndCloseModal,
    cancelButtonText: _i18n.i18n.translate('xpack.transform.transformList.resetModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.transform.transformList.resetModalResetButton', {
      defaultMessage: 'Reset'
    }),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    buttonColor: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, isBulkAction ? bulkResetModalContent : resetModalContent);
};
exports.ResetActionModal = ResetActionModal;