"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleNowAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _transform_list = require("../../../../common/transform_list");
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _schedule_now_action_name = require("./schedule_now_action_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_schedule_now/use_schedule_now_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useScheduleNowAction = (forceDisable, transformNodes) => {
  const {
    canScheduleNowTransform
  } = (0, _hooks.useTransformCapabilities)();
  const scheduleNowTransforms = (0, _hooks.useScheduleNowTransforms)();
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_schedule_now_action_name.ScheduleNowActionName, {
      items: [item],
      forceDisable: forceDisable,
      transformNodes: transformNodes,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }),
    available: item => (0, _transform_list.isTransformListRowWithStats)(item) ? item.stats.state === _constants.TRANSFORM_STATE.STARTED : true,
    enabled: item => (0, _transform_list.isTransformListRowWithStats)(item) && !(0, _schedule_now_action_name.isScheduleNowActionDisabled)([item], canScheduleNowTransform, transformNodes),
    description: _schedule_now_action_name.scheduleNowActionNameText,
    icon: 'play',
    type: 'icon',
    onClick: item => scheduleNowTransforms([{
      id: item.id
    }]),
    'data-test-subj': 'transformActionScheduleNow'
  }), [canScheduleNowTransform, forceDisable, scheduleNowTransforms, transformNodes]);
  return {
    action,
    scheduleNowTransforms
  };
};
exports.useScheduleNowAction = useScheduleNowAction;