"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _stat = require("./stat");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/stats_bar/stats_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    statsBar: (0, _react2.css)`
      height: 42px;
      padding: 14px;
      background-color: ${euiTheme.colors.lightestShade};
    `
  };
};
const StatsBar = ({
  stats,
  dataTestSub
}) => {
  const styles = useStyles();
  const statsList = (0, _react.useMemo)(() => Object.values(stats), [stats]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.statsBar,
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, statsList.filter(s => s.show).map(s => /*#__PURE__*/_react.default.createElement(_stat.Stat, {
    key: s.label,
    stat: s,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  })));
};
exports.StatsBar = StatsBar;