"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformHealthColoredDot = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/transform_list/transform_health_colored_dot.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TransformHealthColoredDot = ({
  healthStatus,
  compact = true,
  showToolTip = true
}) => {
  const transformHealthDescription = _constants.TRANSFORM_HEALTH_DESCRIPTION[healthStatus];
  const transformHealthColor = _constants.TRANSFORM_HEALTH_COLOR[healthStatus];
  const transformHealthLabel = _constants.TRANSFORM_HEALTH_LABEL[healthStatus];
  const health = /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: transformHealthColor,
    textSize: compact ? 'xs' : undefined,
    "data-test-subj": "transformListHealth",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, transformHealthLabel, compact ? '' : `: ${transformHealthDescription}`);
  if (showToolTip) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: transformHealthDescription,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 12
      }
    }, health);
  }
  return health;
};
exports.TransformHealthColoredDot = TransformHealthColoredDot;