"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _action_reauthorize = require("../action_reauthorize");
var _common = require("../../../../common");
var _hooks = require("../../../../hooks");
var _create_transform_button = require("../create_transform_button");
var _refresh_transform_list_button = require("../refresh_transform_list_button");
var _action_delete = require("../action_delete");
var _action_reset = require("../action_reset");
var _action_start = require("../action_start");
var _action_schedule_now = require("../action_schedule_now");
var _action_stop = require("../action_stop");
var _use_columns = require("./use_columns");
var _expanded_row = require("./expanded_row");
var _transform_search_bar_filters = require("./transform_search_bar_filters");
var _use_table_settings = require("./use_table_settings");
var _transform_alerting_flyout = require("../../../../../alerting/transform_alerting_flyout");
var _stop_action_modal = require("../action_stop/stop_action_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/transform_list/transform_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getItemIdToExpandedRowMap(itemIds, transforms, onAlertEdit, transformsStatsLoading) {
  return itemIds.reduce((m, transformId) => {
    const item = transforms.find(transform => transform.config.id === transformId);
    if (item !== undefined) {
      m[transformId] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
        item: item,
        onAlertEdit: onAlertEdit,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 24
        }
      });
    }
    return m;
  }, {});
}
const TransformList = ({
  isLoading,
  onCreateTransform,
  pageState,
  transformNodes,
  transforms,
  transformsLoading,
  transformsStatsLoading,
  updatePageState
}) => {
  var _pageState$queryText;
  const refreshTransformList = (0, _hooks.useRefreshTransformList)();
  const {
    setEditAlertRule
  } = (0, _transform_alerting_flyout.useAlertRuleFlyout)();
  const searchQueryText = (_pageState$queryText = pageState.queryText) !== null && _pageState$queryText !== void 0 ? _pageState$queryText : '';
  const setSearchQueryText = (0, _react.useCallback)(value => {
    updatePageState({
      queryText: value
    });
  }, [updatePageState]);
  const [searchError, setSearchError] = (0, _react.useState)();
  const [expandedRowItemIds, setExpandedRowItemIds] = (0, _react.useState)([]);
  const [transformSelection, setTransformSelection] = (0, _react.useState)([]);
  const [isActionsMenuOpen, setIsActionsMenuOpen] = (0, _react.useState)(false);
  const bulkStartAction = (0, _action_start.useStartAction)(false, transformNodes);
  const bulkDeleteAction = (0, _action_delete.useDeleteAction)(false);
  const bulkReauthorizeAction = (0, _action_reauthorize.useReauthorizeAction)(false, transformNodes);
  const bulkResetAction = (0, _action_reset.useResetAction)(false);
  const bulkStopAction = (0, _action_stop.useStopAction)(false);
  const bulkScheduleNowAction = (0, _action_schedule_now.useScheduleNowAction)(false, transformNodes);
  const capabilities = (0, _hooks.useTransformCapabilities)();
  const disabled = !capabilities.canCreateTransform || !capabilities.canPreviewTransform || !capabilities.canStartStopTransform;
  const {
    sorting,
    pagination,
    onTableChange
  } = (0, _use_table_settings.useTableSettings)(_common.TRANSFORM_LIST_COLUMN.ID, transforms, pageState, updatePageState);
  const {
    columns,
    modals: singleActionModals
  } = (0, _use_columns.useColumns)(expandedRowItemIds, setExpandedRowItemIds, transformNodes, transformSelection, transformsStatsLoading);
  const filteredTransforms = (0, _react.useMemo)(() => {
    var _query$ast$clauses, _query$ast;
    const query = searchQueryText !== '' ? _eui.EuiSearchBar.Query.parse(searchQueryText) : undefined;
    const clauses = (_query$ast$clauses = query === null || query === void 0 ? void 0 : (_query$ast = query.ast) === null || _query$ast === void 0 ? void 0 : _query$ast.clauses) !== null && _query$ast$clauses !== void 0 ? _query$ast$clauses : [];
    return clauses.length > 0 ? (0, _transform_search_bar_filters.filterTransforms)(transforms, clauses) : transforms;
  }, [searchQueryText, transforms]);
  if (transforms.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: 'subdued',
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.transform.list.emptyPromptTitle', {
        defaultMessage: 'No transforms found'
      })),
      actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        fill: true,
        onClick: onCreateTransform,
        isDisabled: disabled,
        "data-test-subj": "transformCreateFirstButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.transform.list.emptyPromptButtonText', {
        defaultMessage: 'Create your first transform'
      }))],
      "data-test-subj": "transformNoTransformsFound",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 7
      }
    });
  }
  const itemIdToExpandedRowMap = getItemIdToExpandedRowMap(expandedRowItemIds, transforms, setEditAlertRule, transformsStatsLoading);
  const bulkActionMenuItems = [/*#__PURE__*/_react.default.createElement("div", {
    key: "startAction",
    className: "transform__BulkActionItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => bulkStartAction.openModal(transformSelection),
    disabled: (0, _action_start.isStartActionDisabled)(transformSelection, capabilities.canStartStopTransform, transformNodes),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_action_start.StartActionName, {
    items: transformSelection,
    transformNodes: transformNodes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "scheduleNowAction",
    className: "transform__BulkActionItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => bulkScheduleNowAction.scheduleNowTransforms(transformSelection.map(i => ({
      id: i.id
    }))),
    disabled: (0, _action_schedule_now.isScheduleNowActionDisabled)(transformSelection, capabilities.canScheduleNowTransform, transformNodes),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_action_schedule_now.ScheduleNowActionName, {
    items: transformSelection,
    transformNodes: transformNodes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "stopAction",
    className: "transform__BulkActionItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      bulkStopAction.openModal(transformSelection);
    },
    disabled: (0, _action_stop.isStopActionDisabled)(transformSelection, capabilities.canStartStopTransform, false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_action_stop.StopActionName, {
    items: transformSelection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "reauthorizeAction",
    className: "transform__BulkActionItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      bulkReauthorizeAction.openModal(transformSelection);
    },
    disabled: (0, _action_reauthorize.isReauthorizeActionDisabled)(transformSelection, capabilities.canStartStopTransform, transformNodes),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_action_reauthorize.ReauthorizeActionName, {
    items: transformSelection,
    transformNodes: transformNodes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "resetAction",
    className: "transform__BulkActionItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      bulkResetAction.openModal(transformSelection);
    },
    disabled: (0, _action_reset.isResetActionDisabled)(transformSelection, false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_action_reset.ResetActionName, {
    canResetTransform: capabilities.canResetTransform,
    disabled: (0, _action_reset.isResetActionDisabled)(transformSelection, false),
    isBulkAction: true,
    items: transformSelection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "deleteAction",
    className: "transform__BulkActionItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => bulkDeleteAction.openModal(transformSelection),
    disabled: (0, _action_delete.isDeleteActionDisabled)(transformSelection, false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_action_delete.DeleteActionName, {
    canDeleteTransform: capabilities.canDeleteTransform,
    disabled: (0, _action_delete.isDeleteActionDisabled)(transformSelection, false),
    isBulkAction: true,
    items: transformSelection,
    forceDisable: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  })))];
  const renderToolsLeft = () => {
    const buttonIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      iconType: "gear",
      color: "text",
      onClick: () => {
        setIsActionsMenuOpen(true);
      },
      "aria-label": _i18n.i18n.translate('xpack.transform.multiTransformActionsMenu.managementActionsAriaLabel', {
        defaultMessage: 'Management actions'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 7
      }
    });
    const bulkActionIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      key: "bulkActionIcon",
      id: "transformBulkActionsMenu",
      button: buttonIcon,
      isOpen: isActionsMenuOpen,
      closePopover: () => setIsActionsMenuOpen(false),
      panelPaddingSize: "s",
      anchorPosition: "rightUp",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 7
      }
    }, bulkActionMenuItems);
    return [/*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      key: "selectedText",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.transform.multiTransformActionsMenu.transformsCount', {
      defaultMessage: '{count} {count, plural, one {transform} other {transforms}} selected',
      values: {
        count: transformSelection.length
      }
    }))), /*#__PURE__*/_react.default.createElement("div", {
      key: "bulkActionsBorder",
      className: "transform__BulkActionsBorder",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 7
      }
    }), bulkActionIcon];
  };
  const toolsRight = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceAround",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_refresh_transform_list_button.RefreshTransformListButton, {
    onClick: refreshTransformList,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_create_transform_button.CreateTransformButton, {
    onClick: onCreateTransform,
    transformNodes: transformNodes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  })));
  const handleSearchOnChange = search => {
    if (search.error !== null) {
      setSearchError(search.error.message);
      return;
    }
    setSearchError(undefined);
    setSearchQueryText(search.queryText);
  };
  const search = {
    toolsLeft: transformSelection.length > 0 ? renderToolsLeft() : undefined,
    toolsRight,
    onChange: handleSearchOnChange,
    box: {
      incremental: true
    },
    filters: _transform_search_bar_filters.transformFilters,
    query: searchQueryText
  };
  const selection = {
    onSelectionChange: selected => setTransformSelection(selected)
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformListTableContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 5
    }
  }, bulkStartAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_start.StartActionModal, (0, _extends2.default)({}, bulkStartAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 42
    }
  })), bulkDeleteAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_delete.DeleteActionModal, (0, _extends2.default)({}, bulkDeleteAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 43
    }
  })), bulkReauthorizeAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_reauthorize.ReauthorizeActionModal, (0, _extends2.default)({}, bulkReauthorizeAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 9
    }
  })), bulkResetAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_reset.ResetActionModal, (0, _extends2.default)({}, bulkResetAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 42
    }
  })), bulkStopAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_stop_action_modal.StopActionModal, (0, _extends2.default)({}, bulkStopAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 41
    }
  })), singleActionModals, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    className: "transform__TransformTable",
    columns: columns,
    error: searchError,
    items: filteredTransforms,
    itemId: _common.TRANSFORM_LIST_COLUMN.ID,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    loading: isLoading || transformsLoading,
    onTableChange: onTableChange,
    pagination: pagination,
    rowProps: item => ({
      'data-test-subj': `transformListRow row-${item.id}`
    }),
    selection: selection,
    sorting: sorting,
    search: search,
    "data-test-subj": `transformListTable ${isLoading || transformsLoading ? 'loading' : 'loaded'}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 7
    }
  }));
};
exports.TransformList = TransformList;