"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExperimentalFeaturesContextProvider = exports.ExperimentalFeaturesContext = exports.EnabledFeaturesContextProvider = exports.EnabledFeaturesContext = void 0;
exports.useEnabledFeatures = useEnabledFeatures;
exports.useExperimentalFeatures = useExperimentalFeatures;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/transform/public/app/serverless_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnabledFeaturesContext = exports.EnabledFeaturesContext = /*#__PURE__*/(0, _react.createContext)({
  showNodeInfo: true
});
const EnabledFeaturesContextProvider = props => {
  const {
    children,
    enabledFeatures
  } = props;
  return /*#__PURE__*/_react.default.createElement(EnabledFeaturesContext.Provider, {
    value: enabledFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, children);
};
exports.EnabledFeaturesContextProvider = EnabledFeaturesContextProvider;
const ExperimentalFeaturesContext = exports.ExperimentalFeaturesContext = /*#__PURE__*/(0, _react.createContext)({
  ruleFormV2Enabled: false
});
const ExperimentalFeaturesContextProvider = props => {
  const {
    children,
    experimentalFeatures
  } = props;
  return /*#__PURE__*/_react.default.createElement(ExperimentalFeaturesContext.Provider, {
    value: experimentalFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, children);
};
exports.ExperimentalFeaturesContextProvider = ExperimentalFeaturesContextProvider;
function useEnabledFeatures() {
  const context = (0, _react.useContext)(EnabledFeaturesContext);
  return (0, _react.useMemo)(() => {
    return context;
  }, [context]);
}
function useExperimentalFeatures() {
  const context = (0, _react.useContext)(ExperimentalFeaturesContext);
  return (0, _react.useMemo)(() => {
    return context;
  }, [context]);
}