"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routeHandler = void 0;
var _error_utils = require("../../utils/error_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const routeHandler = async (ctx, req, res) => {
  const {
    transformId
  } = req.params;
  try {
    const esClient = (await ctx.core).elasticsearch.client;
    const body = await esClient.asCurrentUser.transform.getTransform({
      transform_id: transformId
    });
    return res.ok({
      body
    });
  } catch (e) {
    return res.customError((0, _error_utils.wrapError)((0, _error_utils.wrapEsError)(e)));
  }
};
exports.routeHandler = routeHandler;