"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSPOSE_VISUAL_SEPARATOR = exports.TRANSPOSE_SEPARATOR = void 0;
exports.getOriginalId = getOriginalId;
exports.getTransposeId = getTransposeId;
exports.isTransposeId = isTransposeId;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Used to delimitate felids of a transposed column id
 */
const TRANSPOSE_SEPARATOR = exports.TRANSPOSE_SEPARATOR = '---';

/**
 * Visual deliminator between felids of a transposed column id
 *
 * Meant to align with the `MULTI_FIELD_KEY_SEPARATOR` from the data plugin
 */
const TRANSPOSE_VISUAL_SEPARATOR = exports.TRANSPOSE_VISUAL_SEPARATOR = '›';
function getTransposeId(value, columnId) {
  return `${value}${TRANSPOSE_SEPARATOR}${columnId}`;
}
function isTransposeId(id) {
  return id.split(TRANSPOSE_SEPARATOR).length > 1;
}
function getOriginalId(id) {
  if (id.includes(TRANSPOSE_SEPARATOR)) {
    const idParts = id.split(TRANSPOSE_SEPARATOR);
    return idParts[idParts.length - 1];
  }
  return id;
}