"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAggregationResults = exports.UngroupedGroupId = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UngroupedGroupId = exports.UngroupedGroupId = 'all documents';
const parseAggregationResults = ({
  isCountAgg,
  isGroupAgg,
  esResult,
  resultLimit,
  sourceFieldsParams = [],
  generateSourceFieldsFromHits = false,
  termField
}) => {
  var _aggregations$groupAg, _aggregations$groupAg2, _aggregations$groupAg3;
  const aggregations = (esResult === null || esResult === void 0 ? void 0 : esResult.aggregations) || {};

  // add a fake 'all documents' group aggregation, if a group aggregation wasn't used
  if (!isGroupAgg) {
    var _esResult$hits$hits, _value, _aggregations$metricA;
    aggregations.groupAgg = {
      buckets: [{
        key: UngroupedGroupId,
        doc_count: totalHitsToNumber(esResult.hits.total),
        topHitsAgg: {
          hits: {
            hits: (_esResult$hits$hits = esResult.hits.hits) !== null && _esResult$hits$hits !== void 0 ? _esResult$hits$hits : []
          }
        },
        ...aggregations,
        // sourceFields
        ...(!isCountAgg ? {
          metricAgg: {
            value: (_value = (_aggregations$metricA = aggregations.metricAgg) === null || _aggregations$metricA === void 0 ? void 0 : _aggregations$metricA.value) !== null && _value !== void 0 ? _value : 0
          }
        } : {})
      }]
    };
  }

  // @ts-expect-error specify aggregations type explicitly
  const groupBuckets = ((_aggregations$groupAg = aggregations.groupAgg) === null || _aggregations$groupAg === void 0 ? void 0 : _aggregations$groupAg.buckets) || [];
  // @ts-expect-error specify aggregations type explicitly
  const numGroupsTotal = (_aggregations$groupAg2 = (_aggregations$groupAg3 = aggregations.groupAggCount) === null || _aggregations$groupAg3 === void 0 ? void 0 : _aggregations$groupAg3.count) !== null && _aggregations$groupAg2 !== void 0 ? _aggregations$groupAg2 : 0;
  const results = {
    results: [],
    truncated: resultLimit ? numGroupsTotal > resultLimit : false
  };
  for (const groupBucket of groupBuckets) {
    var _groupBucket$topHitsA4, _groupBucket$topHitsA5, _groupBucket$topHitsA6, _groupBucket$metricAg;
    if (resultLimit && results.results.length === resultLimit) break;
    const groupName = `${groupBucket === null || groupBucket === void 0 ? void 0 : groupBucket.key}`;
    const groupKeys = [termField !== null && termField !== void 0 ? termField : []].flat();
    const groupValues = [groupBucket.key].flat();
    const groups = termField && groupBucket !== null && groupBucket !== void 0 && groupBucket.key ? groupKeys.reduce((resultGroups, groupByItem, groupIndex) => {
      resultGroups.push({
        field: groupByItem,
        value: groupValues[groupIndex]
      });
      return resultGroups;
    }, []) : undefined;
    const groupingObject = termField && groupBucket !== null && groupBucket !== void 0 && groupBucket.key ? groupKeys.reduce((resultGroups, groupByItem, groupIndex) => {
      resultGroups[groupByItem] = groupValues[groupIndex];
      return resultGroups;
    }, {}) : undefined;
    const sourceFields = {};
    if (generateSourceFieldsFromHits) {
      sourceFieldsParams.forEach(field => {
        var _groupBucket$topHitsA, _groupBucket$topHitsA2, _groupBucket$topHitsA3;
        const fieldsSet = [];
        const hits = (_groupBucket$topHitsA = groupBucket === null || groupBucket === void 0 ? void 0 : (_groupBucket$topHitsA2 = groupBucket.topHitsAgg) === null || _groupBucket$topHitsA2 === void 0 ? void 0 : (_groupBucket$topHitsA3 = _groupBucket$topHitsA2.hits) === null || _groupBucket$topHitsA3 === void 0 ? void 0 : _groupBucket$topHitsA3.hits) !== null && _groupBucket$topHitsA !== void 0 ? _groupBucket$topHitsA : [];
        hits.forEach(hit => {
          const sourceField = (0, _lodash.get)(hit._source, field.label);
          if (sourceField) {
            fieldsSet.push(sourceField);
          }
        });
        if (fieldsSet.length > 0) {
          const isArray = Array.isArray(fieldsSet);
          sourceFields[field.label] = Array.from(isArray ? fieldsSet.flat() : fieldsSet);
        }
      });
    }
    const groupResult = {
      group: groupName,
      groups,
      groupingObject,
      count: groupBucket === null || groupBucket === void 0 ? void 0 : groupBucket.doc_count,
      hits: (_groupBucket$topHitsA4 = groupBucket === null || groupBucket === void 0 ? void 0 : (_groupBucket$topHitsA5 = groupBucket.topHitsAgg) === null || _groupBucket$topHitsA5 === void 0 ? void 0 : (_groupBucket$topHitsA6 = _groupBucket$topHitsA5.hits) === null || _groupBucket$topHitsA6 === void 0 ? void 0 : _groupBucket$topHitsA6.hits) !== null && _groupBucket$topHitsA4 !== void 0 ? _groupBucket$topHitsA4 : [],
      ...(!isCountAgg ? {
        value: groupBucket === null || groupBucket === void 0 ? void 0 : (_groupBucket$metricAg = groupBucket.metricAgg) === null || _groupBucket$metricAg === void 0 ? void 0 : _groupBucket$metricAg.value
      } : {}),
      sourceFields
    };
    results.results.push(groupResult);
  }
  return results;
};
exports.parseAggregationResults = parseAggregationResults;
function totalHitsToNumber(total) {
  var _total$value;
  return typeof total === 'number' ? total : (_total$value = total === null || total === void 0 ? void 0 : total.value) !== null && _total$value !== void 0 ? _total$value : 0;
}