"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextFieldWithMessageVariables = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _lib = require("../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/text_field_with_message_variables.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Wrapper = ({
  children,
  wrapField,
  formRowProps,
  button
}) => wrapField ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
  labelAppend: button,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 5
  }
}), children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const TextFieldWithMessageVariables = ({
  buttonTitle,
  messageVariables,
  paramsProperty,
  index,
  inputTargetValue,
  editAction,
  errors,
  formRowProps,
  defaultValue,
  wrapField = false,
  showButtonTitle
}) => {
  const [currentTextElement, setCurrentTextElement] = (0, _react.useState)(null);
  const onSelectMessageVariable = (0, _react.useCallback)(variable => {
    var _currentTextElement$s, _currentTextElement$s2;
    const templatedVar = (0, _lib.templateActionVariable)(variable);
    const startPosition = (_currentTextElement$s = currentTextElement === null || currentTextElement === void 0 ? void 0 : currentTextElement.selectionStart) !== null && _currentTextElement$s !== void 0 ? _currentTextElement$s : 0;
    const endPosition = (_currentTextElement$s2 = currentTextElement === null || currentTextElement === void 0 ? void 0 : currentTextElement.selectionEnd) !== null && _currentTextElement$s2 !== void 0 ? _currentTextElement$s2 : 0;
    const newValue = (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(0, startPosition) + templatedVar + (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(endPosition, (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').length);
    editAction(paramsProperty, newValue, index);
  }, [currentTextElement, editAction, index, inputTargetValue, paramsProperty]);
  const onChangeWithMessageVariable = e => {
    editAction(paramsProperty, e.target.value, index);
  };
  const VariableButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_alertsUiShared.AddMessageVariables, {
    buttonTitle: buttonTitle,
    messageVariables: messageVariables,
    onSelectEventHandler: onSelectMessageVariable,
    paramsProperty: paramsProperty,
    showButtonTitle: showButtonTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), [buttonTitle, messageVariables, onSelectMessageVariable, paramsProperty, showButtonTitle]);
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    wrapField: wrapField,
    formRowProps: formRowProps,
    button: VariableButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    name: paramsProperty,
    id: `${paramsProperty}Id`,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    "data-test-subj": `${paramsProperty}Input`,
    value: inputTargetValue || '',
    defaultValue: defaultValue,
    onChange: e => onChangeWithMessageVariable(e),
    onFocus: e => {
      setCurrentTextElement(e.target);
    },
    onBlur: e => {
      if (!inputTargetValue) {
        editAction(paramsProperty, '', index);
      }
    },
    append: wrapField ? undefined : VariableButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }));
};
exports.TextFieldWithMessageVariables = TextFieldWithMessageVariables;